/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.maybe.MaybePeek;
import io.reactivex.plugins.RxJavaPlugins;

final class MaybePeek$MaybePeekObserver<T>
implements MaybeObserver<T>,
Disposable {
    final MaybeObserver<? super T> actual;
    final MaybePeek<T> parent;
    Disposable d;

    MaybePeek$MaybePeekObserver(MaybeObserver<? super T> actual, MaybePeek<T> parent) {
        this.actual = actual;
        this.parent = parent;
    }

    @Override
    public void dispose() {
        try {
            this.parent.onDisposeCall.run();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            try {
                this.parent.onSubscribeCall.accept(d2);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                d2.dispose();
                this.d = DisposableHelper.DISPOSED;
                EmptyDisposable.error(ex2, this.actual);
                return;
            }
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        if (this.d == DisposableHelper.DISPOSED) {
            return;
        }
        try {
            this.parent.onSuccessCall.accept(value);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.onErrorInner(ex2);
            return;
        }
        this.d = DisposableHelper.DISPOSED;
        this.actual.onSuccess(value);
        this.onAfterTerminate();
    }

    @Override
    public void onError(Throwable e2) {
        if (this.d == DisposableHelper.DISPOSED) {
            RxJavaPlugins.onError(e2);
            return;
        }
        this.onErrorInner(e2);
    }

    void onErrorInner(Throwable e2) {
        try {
            this.parent.onErrorCall.accept(e2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            e2 = new CompositeException(e2, ex2);
        }
        this.d = DisposableHelper.DISPOSED;
        this.actual.onError(e2);
        this.onAfterTerminate();
    }

    @Override
    public void onComplete() {
        if (this.d == DisposableHelper.DISPOSED) {
            return;
        }
        try {
            this.parent.onCompleteCall.run();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.onErrorInner(ex2);
            return;
        }
        this.d = DisposableHelper.DISPOSED;
        this.actual.onComplete();
        this.onAfterTerminate();
    }

    void onAfterTerminate() {
        try {
            this.parent.onAfterTerminate.run();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
    }
}

