/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.MaybeZipArray$ZipMaybeObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class MaybeZipArray$ZipCoordinator<T, R>
extends AtomicInteger
implements Disposable {
    private static final long serialVersionUID = -5556924161382950569L;
    final MaybeObserver<? super R> actual;
    final Function<? super Object[], ? extends R> zipper;
    final MaybeZipArray$ZipMaybeObserver<T>[] observers;
    final Object[] values;

    MaybeZipArray$ZipCoordinator(MaybeObserver<? super R> observer, int n2, Function<? super Object[], ? extends R> zipper) {
        super(n2);
        this.actual = observer;
        this.zipper = zipper;
        MaybeZipArray$ZipMaybeObserver[] o2 = new MaybeZipArray$ZipMaybeObserver[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            o2[i2] = new MaybeZipArray$ZipMaybeObserver(this, i2);
        }
        this.observers = o2;
        this.values = new Object[n2];
    }

    @Override
    public boolean isDisposed() {
        return this.get() <= 0;
    }

    @Override
    public void dispose() {
        if (this.getAndSet(0) > 0) {
            for (MaybeZipArray$ZipMaybeObserver<T> d2 : this.observers) {
                d2.dispose();
            }
        }
    }

    void innerSuccess(T value, int index) {
        this.values[index] = value;
        if (this.decrementAndGet() == 0) {
            R v2;
            try {
                v2 = ObjectHelper.requireNonNull(this.zipper.apply((Object[])this.values), "The zipper returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.actual.onError(ex2);
                return;
            }
            this.actual.onSuccess(v2);
        }
    }

    void disposeExcept(int index) {
        int i2;
        MaybeZipArray$ZipMaybeObserver<T>[] observers = this.observers;
        int n2 = observers.length;
        for (i2 = 0; i2 < index; ++i2) {
            observers[i2].dispose();
        }
        for (i2 = index + 1; i2 < n2; ++i2) {
            observers[i2].dispose();
        }
    }

    void innerError(Throwable ex2, int index) {
        if (this.getAndSet(0) > 0) {
            this.disposeExcept(index);
            this.actual.onError(ex2);
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    void innerComplete(int index) {
        if (this.getAndSet(0) > 0) {
            this.disposeExcept(index);
            this.actual.onComplete();
        }
    }
}

