/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class BlockingObservableIterable$BlockingObservableIterator<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable,
Iterator<T> {
    private static final long serialVersionUID = 6695226475494099826L;
    final SpscLinkedArrayQueue<T> queue;
    final Lock lock;
    final Condition condition;
    volatile boolean done;
    Throwable error;

    BlockingObservableIterable$BlockingObservableIterator(int batchSize) {
        this.queue = new SpscLinkedArrayQueue(batchSize);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        block5: while (true) {
            boolean d2 = this.done;
            boolean empty = this.queue.isEmpty();
            if (d2) {
                Throwable e2 = this.error;
                if (e2 != null) {
                    throw ExceptionHelper.wrapOrThrow(e2);
                }
                if (empty) {
                    return false;
                }
            }
            if (!empty) break;
            try {
                BlockingHelper.verifyNonBlocking();
                this.lock.lock();
                try {
                    while (true) {
                        if (this.done || !this.queue.isEmpty()) continue block5;
                        this.condition.await();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException ex2) {
                DisposableHelper.dispose(this);
                this.signalConsumer();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.queue.poll();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        DisposableHelper.setOnce(this, s2);
    }

    @Override
    public void onNext(T t2) {
        this.queue.offer(t2);
        this.signalConsumer();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        this.signalConsumer();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.signalConsumer();
    }

    void signalConsumer() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

