/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Notification;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

final class BlockingObservableLatest$BlockingObservableLatestIterator<T>
extends DisposableObserver<Notification<T>>
implements Iterator<T> {
    Notification<T> iteratorNotification;
    final Semaphore notify = new Semaphore(0);
    final AtomicReference<Notification<T>> value = new AtomicReference();

    BlockingObservableLatest$BlockingObservableLatestIterator() {
    }

    @Override
    public void onNext(Notification<T> args) {
        boolean wasNotAvailable;
        boolean bl2 = wasNotAvailable = this.value.getAndSet(args) == null;
        if (wasNotAvailable) {
            this.notify.release();
        }
    }

    @Override
    public void onError(Throwable e2) {
        RxJavaPlugins.onError(e2);
    }

    @Override
    public void onComplete() {
    }

    @Override
    public boolean hasNext() {
        if (this.iteratorNotification != null && this.iteratorNotification.isOnError()) {
            throw ExceptionHelper.wrapOrThrow(this.iteratorNotification.getError());
        }
        if (this.iteratorNotification == null) {
            Notification n2;
            try {
                BlockingHelper.verifyNonBlocking();
                this.notify.acquire();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                this.iteratorNotification = Notification.createOnError(ex2);
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
            this.iteratorNotification = n2 = (Notification)this.value.getAndSet(null);
            if (n2.isOnError()) {
                throw ExceptionHelper.wrapOrThrow(n2.getError());
            }
        }
        return this.iteratorNotification.isOnNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T v2 = this.iteratorNotification.getValue();
            this.iteratorNotification = null;
            return v2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Read-only iterator.");
    }
}

