/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Notification;
import io.reactivex.ObservableSource;
import io.reactivex.internal.operators.observable.BlockingObservableNext$NextObserver;
import io.reactivex.internal.operators.observable.ObservableMaterialize;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class BlockingObservableNext$NextIterator<T>
implements Iterator<T> {
    private final BlockingObservableNext$NextObserver<T> observer;
    private final ObservableSource<T> items;
    private T next;
    private boolean hasNext = true;
    private boolean isNextConsumed = true;
    private Throwable error;
    private boolean started;

    BlockingObservableNext$NextIterator(ObservableSource<T> items, BlockingObservableNext$NextObserver<T> observer) {
        this.items = items;
        this.observer = observer;
    }

    @Override
    public boolean hasNext() {
        if (this.error != null) {
            throw ExceptionHelper.wrapOrThrow(this.error);
        }
        if (!this.hasNext) {
            return false;
        }
        return !this.isNextConsumed || this.moveToNext();
    }

    private boolean moveToNext() {
        Notification<T> nextNotification;
        if (!this.started) {
            this.started = true;
            this.observer.setWaiting();
            new ObservableMaterialize<T>(this.items).subscribe(this.observer);
        }
        try {
            nextNotification = this.observer.takeNext();
        }
        catch (InterruptedException e2) {
            this.observer.dispose();
            this.error = e2;
            throw ExceptionHelper.wrapOrThrow(e2);
        }
        if (nextNotification.isOnNext()) {
            this.isNextConsumed = false;
            this.next = nextNotification.getValue();
            return true;
        }
        this.hasNext = false;
        if (nextNotification.isOnComplete()) {
            return false;
        }
        this.error = nextNotification.getError();
        throw ExceptionHelper.wrapOrThrow(this.error);
    }

    @Override
    public T next() {
        if (this.error != null) {
            throw ExceptionHelper.wrapOrThrow(this.error);
        }
        if (this.hasNext()) {
            this.isNextConsumed = true;
            return this.next;
        }
        throw new NoSuchElementException("No more elements");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Read only iterator");
    }
}

