/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Notification;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

final class BlockingObservableNext$NextObserver<T>
extends DisposableObserver<Notification<T>> {
    private final BlockingQueue<Notification<T>> buf = new ArrayBlockingQueue<Notification<T>>(1);
    final AtomicInteger waiting = new AtomicInteger();

    BlockingObservableNext$NextObserver() {
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void onError(Throwable e2) {
        RxJavaPlugins.onError(e2);
    }

    @Override
    public void onNext(Notification<T> args) {
        if (this.waiting.getAndSet(0) == 1 || !args.isOnNext()) {
            Notification toOffer = args;
            while (!this.buf.offer(toOffer)) {
                Notification concurrentItem = (Notification)this.buf.poll();
                if (concurrentItem == null || concurrentItem.isOnNext()) continue;
                toOffer = concurrentItem;
            }
        }
    }

    public Notification<T> takeNext() {
        this.setWaiting();
        BlockingHelper.verifyNonBlocking();
        return this.buf.take();
    }

    void setWaiting() {
        this.waiting.set(1);
    }
}

