/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BlockingObserver;
import io.reactivex.internal.observers.LambdaObserver;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.BlockingIgnoringReceiver;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public final class ObservableBlockingSubscribe {
    private ObservableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(ObservableSource<? extends T> o2, Observer<? super T> observer) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingObserver bs2 = new BlockingObserver((Queue<Object>)queue);
        observer.onSubscribe(bs2);
        o2.subscribe(bs2);
        while (!bs2.isDisposed()) {
            Object v2 = queue.poll();
            if (v2 == null) {
                try {
                    v2 = queue.take();
                }
                catch (InterruptedException ex2) {
                    bs2.dispose();
                    observer.onError(ex2);
                    return;
                }
            }
            if (!bs2.isDisposed() && o2 != BlockingObserver.TERMINATED && !NotificationLite.acceptFull(v2, observer)) continue;
            break;
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o2) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaObserver ls2 = new LambdaObserver(Functions.emptyConsumer(), callback, callback, Functions.emptyConsumer());
        o2.subscribe(ls2);
        BlockingHelper.awaitForComplete(callback, ls2);
        Throwable e2 = callback.error;
        if (e2 != null) {
            throw ExceptionHelper.wrapOrThrow(e2);
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o2, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ObservableBlockingSubscribe.subscribe(o2, new LambdaObserver<T>(onNext, onError, onComplete, Functions.emptyConsumer()));
    }
}

