/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.Collection;
import java.util.concurrent.Callable;

final class ObservableBuffer$BufferExactObserver<T, U extends Collection<? super T>>
implements Observer<T>,
Disposable {
    final Observer<? super U> actual;
    final int count;
    final Callable<U> bufferSupplier;
    U buffer;
    int size;
    Disposable s;

    ObservableBuffer$BufferExactObserver(Observer<? super U> actual, int count, Callable<U> bufferSupplier) {
        this.actual = actual;
        this.count = count;
        this.bufferSupplier = bufferSupplier;
    }

    boolean createBuffer() {
        Collection b2;
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "Empty buffer supplied");
        }
        catch (Throwable t2) {
            Exceptions.throwIfFatal(t2);
            this.buffer = null;
            if (this.s == null) {
                EmptyDisposable.error(t2, this.actual);
            } else {
                this.s.dispose();
                this.actual.onError(t2);
            }
            return false;
        }
        this.buffer = b2;
        return true;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        U b2 = this.buffer;
        if (b2 != null) {
            b2.add(t2);
            if (++this.size >= this.count) {
                this.actual.onNext(b2);
                this.size = 0;
                this.createBuffer();
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.buffer = null;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        U b2 = this.buffer;
        this.buffer = null;
        if (b2 != null && !b2.isEmpty()) {
            this.actual.onNext(b2);
        }
        this.actual.onComplete();
    }
}

