/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.ObservableBufferBoundary$BufferBoundaryObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableBufferBoundary$BufferCloseObserver<T, C extends Collection<? super T>>
extends AtomicReference<Disposable>
implements Observer<Object>,
Disposable {
    private static final long serialVersionUID = -8498650778633225126L;
    final ObservableBufferBoundary$BufferBoundaryObserver<T, C, ?, ?> parent;
    final long index;

    ObservableBufferBoundary$BufferCloseObserver(ObservableBufferBoundary$BufferBoundaryObserver<T, C, ?, ?> parent, long index) {
        this.parent = parent;
        this.index = index;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        DisposableHelper.setOnce(this, s2);
    }

    @Override
    public void onNext(Object t2) {
        Disposable s2 = (Disposable)this.get();
        if (s2 != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            s2.dispose();
            this.parent.close(this, this.index);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.get() != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            this.parent.boundaryError(this, t2);
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.get() != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            this.parent.close(this, this.index);
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }
}

