/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.ObservableBufferBoundarySupplier$BufferBoundaryObserver;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableBufferBoundarySupplier$BufferBoundarySupplierObserver<T, U extends Collection<? super T>, B>
extends QueueDrainObserver<T, U, U>
implements Observer<T>,
Disposable {
    final Callable<U> bufferSupplier;
    final Callable<? extends ObservableSource<B>> boundarySupplier;
    Disposable s;
    final AtomicReference<Disposable> other = new AtomicReference();
    U buffer;

    ObservableBufferBoundarySupplier$BufferBoundarySupplierObserver(Observer<? super U> actual, Callable<U> bufferSupplier, Callable<? extends ObservableSource<B>> boundarySupplier) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.boundarySupplier = boundarySupplier;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            ObservableSource<B> boundary;
            Collection b2;
            this.s = s2;
            Observer actual = this.actual;
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancelled = true;
                s2.dispose();
                EmptyDisposable.error(e2, actual);
                return;
            }
            this.buffer = b2;
            try {
                boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary ObservableSource supplied is null");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.cancelled = true;
                s2.dispose();
                EmptyDisposable.error(ex2, actual);
                return;
            }
            ObservableBufferBoundarySupplier$BufferBoundaryObserver bs2 = new ObservableBufferBoundarySupplier$BufferBoundaryObserver(this);
            this.other.set(bs2);
            actual.onSubscribe(this);
            if (!this.cancelled) {
                boundary.subscribe(bs2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        ObservableBufferBoundarySupplier$BufferBoundarySupplierObserver observableBufferBoundarySupplier$BufferBoundarySupplierObserver = this;
        synchronized (observableBufferBoundarySupplier$BufferBoundarySupplierObserver) {
            U b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            b2.add(t2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.dispose();
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        ObservableBufferBoundarySupplier$BufferBoundarySupplierObserver observableBufferBoundarySupplier$BufferBoundarySupplierObserver = this;
        synchronized (observableBufferBoundarySupplier$BufferBoundarySupplierObserver) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = null;
        }
        this.queue.offer(b2);
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainLoop(this.queue, this.actual, false, this, this);
        }
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.dispose();
            this.disposeOther();
            if (this.enter()) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void disposeOther() {
        DisposableHelper.dispose(this.other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void next() {
        U b2;
        ObservableSource<B> boundary;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.dispose();
            this.actual.onError(e2);
            return;
        }
        try {
            boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary ObservableSource supplied is null");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.cancelled = true;
            this.s.dispose();
            this.actual.onError(ex2);
            return;
        }
        ObservableBufferBoundarySupplier$BufferBoundaryObserver bs2 = new ObservableBufferBoundarySupplier$BufferBoundaryObserver(this);
        Disposable o2 = this.other.get();
        if (!this.other.compareAndSet(o2, bs2)) {
            return;
        }
        ObservableBufferBoundarySupplier$BufferBoundarySupplierObserver observableBufferBoundarySupplier$BufferBoundarySupplierObserver = this;
        synchronized (observableBufferBoundarySupplier$BufferBoundarySupplierObserver) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = next;
        }
        boundary.subscribe(bs2);
        this.fastPathEmit(b2, false, this);
    }

    @Override
    public void accept(Observer<? super U> a2, U v2) {
        this.actual.onNext(v2);
    }
}

