/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class ObservableBufferTimed$BufferExactBoundedObserver<T, U extends Collection<? super T>>
extends QueueDrainObserver<T, U, U>
implements Disposable,
Runnable {
    final Callable<U> bufferSupplier;
    final long timespan;
    final TimeUnit unit;
    final int maxSize;
    final boolean restartTimerOnMaxSize;
    final Scheduler$Worker w;
    U buffer;
    Disposable timer;
    Disposable s;
    long producerIndex;
    long consumerIndex;

    ObservableBufferTimed$BufferExactBoundedObserver(Observer<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, int maxSize, boolean restartOnMaxSize, Scheduler$Worker w2) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.timespan = timespan;
        this.unit = unit;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartOnMaxSize;
        this.w = w2;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            Collection b2;
            this.s = s2;
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                s2.dispose();
                EmptyDisposable.error(e2, this.actual);
                this.w.dispose();
                return;
            }
            this.buffer = b2;
            this.actual.onSubscribe(this);
            this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        Object b2;
        ObservableBufferTimed$BufferExactBoundedObserver observableBufferTimed$BufferExactBoundedObserver = this;
        synchronized (observableBufferTimed$BufferExactBoundedObserver) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            b2.add(t2);
            if (b2.size() < this.maxSize) {
                return;
            }
            this.buffer = null;
            ++this.producerIndex;
        }
        if (this.restartTimerOnMaxSize) {
            this.timer.dispose();
        }
        this.fastPathOrderedEmit(b2, false, this);
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            this.dispose();
            return;
        }
        observableBufferTimed$BufferExactBoundedObserver = this;
        synchronized (observableBufferTimed$BufferExactBoundedObserver) {
            this.buffer = b2;
            ++this.consumerIndex;
        }
        if (this.restartTimerOnMaxSize) {
            this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        ObservableBufferTimed$BufferExactBoundedObserver observableBufferTimed$BufferExactBoundedObserver = this;
        synchronized (observableBufferTimed$BufferExactBoundedObserver) {
            this.buffer = null;
        }
        this.actual.onError(t2);
        this.w.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        this.w.dispose();
        ObservableBufferTimed$BufferExactBoundedObserver observableBufferTimed$BufferExactBoundedObserver = this;
        synchronized (observableBufferTimed$BufferExactBoundedObserver) {
            b2 = this.buffer;
            this.buffer = null;
        }
        this.queue.offer(b2);
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainLoop(this.queue, this.actual, false, this, this);
        }
    }

    @Override
    public void accept(Observer<? super U> a2, U v2) {
        a2.onNext(v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.dispose();
            this.w.dispose();
            ObservableBufferTimed$BufferExactBoundedObserver observableBufferTimed$BufferExactBoundedObserver = this;
            synchronized (observableBufferTimed$BufferExactBoundedObserver) {
                this.buffer = null;
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        U current;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.dispose();
            this.actual.onError(e2);
            return;
        }
        ObservableBufferTimed$BufferExactBoundedObserver observableBufferTimed$BufferExactBoundedObserver = this;
        synchronized (observableBufferTimed$BufferExactBoundedObserver) {
            current = this.buffer;
            if (current == null || this.producerIndex != this.consumerIndex) {
                return;
            }
            this.buffer = next;
        }
        this.fastPathOrderedEmit(current, false, this);
    }
}

