/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableBufferTimed$BufferExactUnboundedObserver<T, U extends Collection<? super T>>
extends QueueDrainObserver<T, U, U>
implements Disposable,
Runnable {
    final Callable<U> bufferSupplier;
    final long timespan;
    final TimeUnit unit;
    final Scheduler scheduler;
    Disposable s;
    U buffer;
    final AtomicReference<Disposable> timer = new AtomicReference();

    ObservableBufferTimed$BufferExactUnboundedObserver(Observer<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, Scheduler scheduler) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.timespan = timespan;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            Disposable d2;
            Collection b2;
            this.s = s2;
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.dispose();
                EmptyDisposable.error(e2, this.actual);
                return;
            }
            this.buffer = b2;
            this.actual.onSubscribe(this);
            if (!this.cancelled && !this.timer.compareAndSet(null, d2 = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit))) {
                d2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        ObservableBufferTimed$BufferExactUnboundedObserver observableBufferTimed$BufferExactUnboundedObserver = this;
        synchronized (observableBufferTimed$BufferExactUnboundedObserver) {
            U b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            b2.add(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        ObservableBufferTimed$BufferExactUnboundedObserver observableBufferTimed$BufferExactUnboundedObserver = this;
        synchronized (observableBufferTimed$BufferExactUnboundedObserver) {
            this.buffer = null;
        }
        this.actual.onError(t2);
        DisposableHelper.dispose(this.timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        ObservableBufferTimed$BufferExactUnboundedObserver observableBufferTimed$BufferExactUnboundedObserver = this;
        synchronized (observableBufferTimed$BufferExactUnboundedObserver) {
            b2 = this.buffer;
            this.buffer = null;
        }
        if (b2 != null) {
            this.queue.offer(b2);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.actual, false, null, this);
            }
        }
        DisposableHelper.dispose(this.timer);
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.timer);
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.timer.get() == DisposableHelper.DISPOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        U current;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            this.dispose();
            return;
        }
        ObservableBufferTimed$BufferExactUnboundedObserver observableBufferTimed$BufferExactUnboundedObserver = this;
        synchronized (observableBufferTimed$BufferExactUnboundedObserver) {
            current = this.buffer;
            if (current != null) {
                this.buffer = next;
            }
        }
        if (current == null) {
            DisposableHelper.dispose(this.timer);
            return;
        }
        this.fastPathEmit(current, false, this);
    }

    @Override
    public void accept(Observer<? super U> a2, U v2) {
        this.actual.onNext(v2);
    }
}

