/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableBufferTimed$BufferExactBoundedObserver;
import io.reactivex.internal.operators.observable.ObservableBufferTimed$BufferExactUnboundedObserver;
import io.reactivex.internal.operators.observable.ObservableBufferTimed$BufferSkipBoundedObserver;
import io.reactivex.observers.SerializedObserver;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class ObservableBufferTimed<T, U extends Collection<? super T>>
extends AbstractObservableWithUpstream<T, U> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Callable<U> bufferSupplier;
    final int maxSize;
    final boolean restartTimerOnMaxSize;

    public ObservableBufferTimed(ObservableSource<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Callable<U> bufferSupplier, int maxSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSupplier = bufferSupplier;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    public void subscribeActual(Observer<? super U> t2) {
        if (this.timespan == this.timeskip && this.maxSize == Integer.MAX_VALUE) {
            this.source.subscribe(new ObservableBufferTimed$BufferExactUnboundedObserver(new SerializedObserver<U>(t2), this.bufferSupplier, this.timespan, this.unit, this.scheduler));
            return;
        }
        Scheduler$Worker w2 = this.scheduler.createWorker();
        if (this.timespan == this.timeskip) {
            this.source.subscribe(new ObservableBufferTimed$BufferExactBoundedObserver(new SerializedObserver<U>(t2), this.bufferSupplier, this.timespan, this.unit, this.maxSize, this.restartTimerOnMaxSize, w2));
            return;
        }
        this.source.subscribe(new ObservableBufferTimed$BufferSkipBoundedObserver(new SerializedObserver<U>(t2), this.bufferSupplier, this.timespan, this.timeskip, this.unit, w2));
    }
}

