/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.observable.ObservableCache$ReplayDisposable;
import io.reactivex.internal.util.LinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableCache$CacheState<T>
extends LinkedArrayList
implements Observer<T> {
    final Observable<? extends T> source;
    final SequentialDisposable connection;
    final AtomicReference<ObservableCache$ReplayDisposable<T>[]> observers;
    static final ObservableCache$ReplayDisposable[] EMPTY = new ObservableCache$ReplayDisposable[0];
    static final ObservableCache$ReplayDisposable[] TERMINATED = new ObservableCache$ReplayDisposable[0];
    volatile boolean isConnected;
    boolean sourceDone;

    ObservableCache$CacheState(Observable<? extends T> source, int capacityHint) {
        super(capacityHint);
        this.source = source;
        this.observers = new AtomicReference<ObservableCache$ReplayDisposable[]>(EMPTY);
        this.connection = new SequentialDisposable();
    }

    public boolean addChild(ObservableCache$ReplayDisposable<T> p2) {
        ObservableCache$ReplayDisposable[] b2;
        ObservableCache$ReplayDisposable<T>[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new ObservableCache$ReplayDisposable[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = p2;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    public void removeChild(ObservableCache$ReplayDisposable<T> p2) {
        ObservableCache$ReplayDisposable[] b2;
        ObservableCache$ReplayDisposable<T>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!a2[i2].equals(p2)) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new ObservableCache$ReplayDisposable[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }

    @Override
    public void onSubscribe(Disposable s2) {
        this.connection.update(s2);
    }

    public void connect() {
        this.source.subscribe(this);
        this.isConnected = true;
    }

    @Override
    public void onNext(T t2) {
        if (!this.sourceDone) {
            Object o2 = NotificationLite.next(t2);
            this.add(o2);
            for (ObservableCache$ReplayDisposable<T> rp2 : this.observers.get()) {
                rp2.replay();
            }
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (!this.sourceDone) {
            this.sourceDone = true;
            Object o2 = NotificationLite.error(e2);
            this.add(o2);
            this.connection.dispose();
            for (ObservableCache$ReplayDisposable rp2 : this.observers.getAndSet(TERMINATED)) {
                rp2.replay();
            }
        }
    }

    @Override
    public void onComplete() {
        if (!this.sourceDone) {
            this.sourceDone = true;
            Object o2 = NotificationLite.complete();
            this.add(o2);
            this.connection.dispose();
            for (ObservableCache$ReplayDisposable rp2 : this.observers.getAndSet(TERMINATED)) {
                rp2.replay();
            }
        }
    }
}

