/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableCache$CacheState;
import io.reactivex.internal.operators.observable.ObservableCache$ReplayDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableCache<T>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableCache$CacheState<T> state;
    final AtomicBoolean once;

    public static <T> Observable<T> from(Observable<T> source) {
        return ObservableCache.from(source, 16);
    }

    public static <T> Observable<T> from(Observable<T> source, int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        ObservableCache$CacheState<T> state = new ObservableCache$CacheState<T>(source, capacityHint);
        return RxJavaPlugins.onAssembly(new ObservableCache<T>(source, state));
    }

    private ObservableCache(Observable<T> source, ObservableCache$CacheState<T> state) {
        super(source);
        this.state = state;
        this.once = new AtomicBoolean();
    }

    @Override
    public void subscribeActual(Observer<? super T> t2) {
        ObservableCache$ReplayDisposable<T> rp2 = new ObservableCache$ReplayDisposable<T>(t2, this.state);
        t2.onSubscribe(rp2);
        this.state.addChild(rp2);
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.state.connect();
        }
        rp2.replay();
    }

    boolean isConnected() {
        return this.state.isConnected;
    }

    boolean hasObservers() {
        return this.state.observers.get().length != 0;
    }

    int cachedEventCount() {
        return this.state.size();
    }
}

