/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableCombineLatest$CombinerObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableCombineLatest$LatestCoordinator<T, R>
extends AtomicInteger
implements Disposable {
    private static final long serialVersionUID = 8567835998786448817L;
    final Observer<? super R> actual;
    final Function<? super Object[], ? extends R> combiner;
    final ObservableCombineLatest$CombinerObserver<T, R>[] observers;
    Object[] latest;
    final SpscLinkedArrayQueue<Object[]> queue;
    final boolean delayError;
    volatile boolean cancelled;
    volatile boolean done;
    final AtomicThrowable errors = new AtomicThrowable();
    int active;
    int complete;

    ObservableCombineLatest$LatestCoordinator(Observer<? super R> actual, Function<? super Object[], ? extends R> combiner, int count, int bufferSize, boolean delayError) {
        this.actual = actual;
        this.combiner = combiner;
        this.delayError = delayError;
        this.latest = new Object[count];
        ObservableCombineLatest$CombinerObserver[] as2 = new ObservableCombineLatest$CombinerObserver[count];
        for (int i2 = 0; i2 < count; ++i2) {
            as2[i2] = new ObservableCombineLatest$CombinerObserver(this, i2);
        }
        this.observers = as2;
        this.queue = new SpscLinkedArrayQueue(bufferSize);
    }

    public void subscribe(ObservableSource<? extends T>[] sources) {
        ObservableCombineLatest$CombinerObserver<T, R>[] as2 = this.observers;
        int len = as2.length;
        this.actual.onSubscribe(this);
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.done || this.cancelled) {
                return;
            }
            sources[i2].subscribe(as2[i2]);
        }
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.cancelSources();
            if (this.getAndIncrement() == 0) {
                this.clear(this.queue);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void cancelSources() {
        for (ObservableCombineLatest$CombinerObserver<T, R> s2 : this.observers) {
            s2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(SpscLinkedArrayQueue<?> q2) {
        ObservableCombineLatest$LatestCoordinator observableCombineLatest$LatestCoordinator = this;
        synchronized (observableCombineLatest$LatestCoordinator) {
            this.latest = null;
        }
        q2.clear();
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        SpscLinkedArrayQueue<Object[]> q2 = this.queue;
        Observer<R> a2 = this.actual;
        boolean delayError = this.delayError;
        int missed = 1;
        while (true) {
            boolean empty;
            if (this.cancelled) {
                this.clear(q2);
                return;
            }
            if (!delayError && this.errors.get() != null) {
                this.cancelSources();
                this.clear(q2);
                a2.onError(this.errors.terminate());
                return;
            }
            boolean d2 = this.done;
            Object[] s2 = q2.poll();
            boolean bl2 = empty = s2 == null;
            if (d2 && empty) {
                this.clear(q2);
                Throwable ex2 = this.errors.terminate();
                if (ex2 == null) {
                    a2.onComplete();
                } else {
                    a2.onError(ex2);
                }
                return;
            }
            if (!empty) {
                R v2;
                try {
                    v2 = ObjectHelper.requireNonNull(this.combiner.apply((Object[])s2), "The combiner returned a null value");
                }
                catch (Throwable ex3) {
                    Exceptions.throwIfFatal(ex3);
                    this.errors.addThrowable(ex3);
                    this.cancelSources();
                    this.clear(q2);
                    ex3 = this.errors.terminate();
                    a2.onError(ex3);
                    return;
                }
                a2.onNext(v2);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void innerNext(int index, T item) {
        boolean shouldDrain = false;
        ObservableCombineLatest$LatestCoordinator observableCombineLatest$LatestCoordinator = this;
        synchronized (observableCombineLatest$LatestCoordinator) {
            Object[] latest = this.latest;
            if (latest == null) {
                return;
            }
            Object o2 = latest[index];
            int a2 = this.active;
            if (o2 == null) {
                this.active = ++a2;
            }
            latest[index] = item;
            if (a2 == latest.length) {
                this.queue.offer((Object[])latest.clone());
                shouldDrain = true;
            }
        }
        if (shouldDrain) {
            this.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void innerError(int index, Throwable ex2) {
        if (this.errors.addThrowable(ex2)) {
            boolean cancelOthers = true;
            if (this.delayError) {
                ObservableCombineLatest$LatestCoordinator observableCombineLatest$LatestCoordinator = this;
                synchronized (observableCombineLatest$LatestCoordinator) {
                    Object[] latest = this.latest;
                    if (latest == null) {
                        return;
                    }
                    boolean bl2 = cancelOthers = latest[index] == null;
                    if (cancelOthers || ++this.complete == latest.length) {
                        this.done = true;
                    }
                }
            }
            if (cancelOthers) {
                this.cancelSources();
            }
            this.drain();
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void innerComplete(int index) {
        boolean cancelOthers = false;
        ObservableCombineLatest$LatestCoordinator observableCombineLatest$LatestCoordinator = this;
        synchronized (observableCombineLatest$LatestCoordinator) {
            Object[] latest = this.latest;
            if (latest == null) {
                return;
            }
            boolean bl2 = cancelOthers = latest[index] == null;
            if (cancelOthers || ++this.complete == latest.length) {
                this.done = true;
            }
        }
        if (cancelOthers) {
            this.cancelSources();
        }
        this.drain();
    }
}

