/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.ObservableConcatMap$ConcatMapDelayErrorObserver$DelayErrorInnerObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableConcatMap$ConcatMapDelayErrorObserver<T, R>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -6951100001833242599L;
    final Observer<? super R> actual;
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
    final int bufferSize;
    final AtomicThrowable error;
    final ObservableConcatMap$ConcatMapDelayErrorObserver$DelayErrorInnerObserver<R> observer;
    final boolean tillTheEnd;
    SimpleQueue<T> queue;
    Disposable d;
    volatile boolean active;
    volatile boolean done;
    volatile boolean cancelled;
    int sourceMode;

    ObservableConcatMap$ConcatMapDelayErrorObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean tillTheEnd) {
        this.actual = actual;
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.tillTheEnd = tillTheEnd;
        this.error = new AtomicThrowable();
        this.observer = new ObservableConcatMap$ConcatMapDelayErrorObserver$DelayErrorInnerObserver<R>(actual, this);
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            if (d2 instanceof QueueDisposable) {
                QueueDisposable qd2 = (QueueDisposable)d2;
                int m2 = qd2.requestFusion(3);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = qd2;
                    this.done = true;
                    this.actual.onSubscribe(this);
                    this.drain();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = qd2;
                    this.actual.onSubscribe(this);
                    return;
                }
            }
            this.queue = new SpscLinkedArrayQueue(this.bufferSize);
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T value) {
        if (this.sourceMode == 0) {
            this.queue.offer(value);
        }
        this.drain();
    }

    @Override
    public void onError(Throwable e2) {
        if (this.error.addThrowable(e2)) {
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    @Override
    public void dispose() {
        this.cancelled = true;
        this.d.dispose();
        this.observer.dispose();
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Observer<R> actual = this.actual;
        SimpleQueue<T> queue = this.queue;
        AtomicThrowable error = this.error;
        while (true) {
            if (!this.active) {
                boolean empty;
                T v2;
                Throwable ex2;
                if (this.cancelled) {
                    queue.clear();
                    return;
                }
                if (!this.tillTheEnd && (ex2 = (Throwable)error.get()) != null) {
                    queue.clear();
                    this.cancelled = true;
                    actual.onError(error.terminate());
                    return;
                }
                boolean d2 = this.done;
                try {
                    v2 = queue.poll();
                }
                catch (Throwable ex3) {
                    Exceptions.throwIfFatal(ex3);
                    this.cancelled = true;
                    this.d.dispose();
                    error.addThrowable(ex3);
                    actual.onError(error.terminate());
                    return;
                }
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    this.cancelled = true;
                    Throwable ex4 = error.terminate();
                    if (ex4 != null) {
                        actual.onError(ex4);
                    } else {
                        actual.onComplete();
                    }
                    return;
                }
                if (!empty) {
                    ObservableSource<R> o2;
                    try {
                        o2 = ObjectHelper.requireNonNull(this.mapper.apply(v2), "The mapper returned a null ObservableSource");
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        this.cancelled = true;
                        this.d.dispose();
                        queue.clear();
                        error.addThrowable(ex5);
                        actual.onError(error.terminate());
                        return;
                    }
                    if (o2 instanceof Callable) {
                        Object w2;
                        try {
                            w2 = ((Callable)((Object)o2)).call();
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            error.addThrowable(ex6);
                            continue;
                        }
                        if (w2 == null || this.cancelled) continue;
                        actual.onNext(w2);
                        continue;
                    }
                    this.active = true;
                    o2.subscribe(this.observer);
                }
            }
            if (this.decrementAndGet() == 0) break;
        }
    }
}

