/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableEmitter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.disposables.CancellableDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.ObservableCreate$SerializedEmitter;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableCreate$CreateEmitter<T>
extends AtomicReference<Disposable>
implements ObservableEmitter<T>,
Disposable {
    private static final long serialVersionUID = -3434801548987643227L;
    final Observer<? super T> observer;

    ObservableCreate$CreateEmitter(Observer<? super T> observer) {
        this.observer = observer;
    }

    @Override
    public void onNext(T t2) {
        if (t2 == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        if (!this.isDisposed()) {
            this.observer.onNext(t2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.tryOnError(t2)) {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public boolean tryOnError(Throwable t2) {
        if (t2 == null) {
            t2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (!this.isDisposed()) {
            try {
                this.observer.onError(t2);
            }
            finally {
                this.dispose();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onComplete() {
        if (!this.isDisposed()) {
            try {
                this.observer.onComplete();
            }
            finally {
                this.dispose();
            }
        }
    }

    @Override
    public void setDisposable(Disposable d2) {
        DisposableHelper.set(this, d2);
    }

    @Override
    public void setCancellable(Cancellable c2) {
        this.setDisposable(new CancellableDisposable(c2));
    }

    @Override
    public ObservableEmitter<T> serialize() {
        return new ObservableCreate$SerializedEmitter(this);
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

