/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.annotations.Nullable;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicFuseableObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;

final class ObservableDistinct$DistinctObserver<T, K>
extends BasicFuseableObserver<T, T> {
    final Collection<? super K> collection;
    final Function<? super T, K> keySelector;

    ObservableDistinct$DistinctObserver(Observer<? super T> actual, Function<? super T, K> keySelector, Collection<? super K> collection) {
        super(actual);
        this.keySelector = keySelector;
        this.collection = collection;
    }

    @Override
    public void onNext(T value) {
        if (this.done) {
            return;
        }
        if (this.sourceMode == 0) {
            boolean b2;
            try {
                K key = ObjectHelper.requireNonNull(this.keySelector.apply(value), "The keySelector returned a null key");
                b2 = this.collection.add(key);
            }
            catch (Throwable ex2) {
                this.fail(ex2);
                return;
            }
            if (b2) {
                this.actual.onNext(value);
            }
        } else {
            this.actual.onNext(null);
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (this.done) {
            RxJavaPlugins.onError(e2);
        } else {
            this.done = true;
            this.collection.clear();
            this.actual.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.collection.clear();
            this.actual.onComplete();
        }
    }

    @Override
    public int requestFusion(int mode) {
        return this.transitiveBoundaryFusion(mode);
    }

    @Override
    @Nullable
    public T poll() {
        Object v2;
        while ((v2 = this.qs.poll()) != null && !this.collection.add(ObjectHelper.requireNonNull(this.keySelector.apply(v2), "The keySelector returned a null key"))) {
        }
        return v2;
    }

    @Override
    public void clear() {
        this.collection.clear();
        super.clear();
    }
}

