/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.annotations.Nullable;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Function;
import io.reactivex.internal.observers.BasicFuseableObserver;

final class ObservableDistinctUntilChanged$DistinctUntilChangedObserver<T, K>
extends BasicFuseableObserver<T, T> {
    final Function<? super T, K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;
    K last;
    boolean hasValue;

    ObservableDistinctUntilChanged$DistinctUntilChangedObserver(Observer<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        super(actual);
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.sourceMode != 0) {
            this.actual.onNext(t2);
            return;
        }
        try {
            K key = this.keySelector.apply(t2);
            if (this.hasValue) {
                boolean equal = this.comparer.test(this.last, key);
                this.last = key;
                if (equal) {
                    return;
                }
            } else {
                this.hasValue = true;
                this.last = key;
            }
        }
        catch (Throwable ex2) {
            this.fail(ex2);
            return;
        }
        this.actual.onNext(t2);
    }

    @Override
    public int requestFusion(int mode) {
        return this.transitiveBoundaryFusion(mode);
    }

    @Override
    @Nullable
    public T poll() {
        Object v2;
        while ((v2 = this.qs.poll()) != null) {
            K key = this.keySelector.apply(v2);
            if (!this.hasValue) {
                this.hasValue = true;
                this.last = key;
                return v2;
            }
            if (!this.comparer.test(this.last, key)) {
                this.last = key;
                return v2;
            }
            this.last = key;
        }
        return null;
    }
}

