/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableDoFinally$DoFinallyObserver<T>
extends BasicIntQueueDisposable<T>
implements Observer<T> {
    private static final long serialVersionUID = 4109457741734051389L;
    final Observer<? super T> actual;
    final Action onFinally;
    Disposable d;
    QueueDisposable<T> qd;
    boolean syncFused;

    ObservableDoFinally$DoFinallyObserver(Observer<? super T> actual, Action onFinally) {
        this.actual = actual;
        this.onFinally = onFinally;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            if (d2 instanceof QueueDisposable) {
                this.qd = (QueueDisposable)d2;
            }
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
        this.runFinally();
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
        this.runFinally();
    }

    @Override
    public void dispose() {
        this.d.dispose();
        this.runFinally();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public int requestFusion(int mode) {
        QueueDisposable<T> qd2 = this.qd;
        if (qd2 != null && (mode & 4) == 0) {
            int m2 = qd2.requestFusion(mode);
            if (m2 != 0) {
                this.syncFused = m2 == 1;
            }
            return m2;
        }
        return 0;
    }

    @Override
    public void clear() {
        this.qd.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.qd.isEmpty();
    }

    @Override
    @Nullable
    public T poll() {
        Object v2 = this.qd.poll();
        if (v2 == null && this.syncFused) {
            this.runFinally();
        }
        return v2;
    }

    void runFinally() {
        if (this.compareAndSet(0, 1)) {
            try {
                this.onFinally.run();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                RxJavaPlugins.onError(ex2);
            }
        }
    }
}

