/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableDoOnEach$DoOnEachObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminate;
    Disposable s;
    boolean done;

    ObservableDoOnEach$DoOnEachObserver(Observer<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        this.actual = actual;
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminate = onAfterTerminate;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        try {
            this.onNext.accept(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.s.dispose();
            this.onError(e2);
            return;
        }
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        try {
            this.onError.accept(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            t2 = new CompositeException(t2, e2);
        }
        this.actual.onError(t2);
        try {
            this.onAfterTerminate.run();
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(e3);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        try {
            this.onComplete.run();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.onError(e2);
            return;
        }
        this.done = true;
        this.actual.onComplete();
        try {
            this.onAfterTerminate.run();
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(e3);
        }
    }
}

