/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.ObservableFlatMap$InnerObserver;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableFlatMap$MergeObserver<T, U>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -2117620485640801370L;
    final Observer<? super U> actual;
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;
    volatile SimplePlainQueue<U> queue;
    volatile boolean done;
    final AtomicThrowable errors = new AtomicThrowable();
    volatile boolean cancelled;
    final AtomicReference<ObservableFlatMap$InnerObserver<?, ?>[]> observers;
    static final ObservableFlatMap$InnerObserver<?, ?>[] EMPTY = new ObservableFlatMap$InnerObserver[0];
    static final ObservableFlatMap$InnerObserver<?, ?>[] CANCELLED = new ObservableFlatMap$InnerObserver[0];
    Disposable s;
    long uniqueId;
    long lastId;
    int lastIndex;
    Queue<ObservableSource<? extends U>> sources;
    int wip;

    ObservableFlatMap$MergeObserver(Observer<? super U> actual, Function<? super T, ? extends ObservableSource<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        this.actual = actual;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
        if (maxConcurrency != Integer.MAX_VALUE) {
            this.sources = new ArrayDeque<ObservableSource<? extends U>>(maxConcurrency);
        }
        this.observers = new AtomicReference<ObservableFlatMap$InnerObserver<?, ?>[]>(EMPTY);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        ObservableSource<? extends U> p2;
        if (this.done) {
            return;
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null ObservableSource");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.s.dispose();
            this.onError(e2);
            return;
        }
        if (this.maxConcurrency != Integer.MAX_VALUE) {
            ObservableFlatMap$MergeObserver observableFlatMap$MergeObserver = this;
            synchronized (observableFlatMap$MergeObserver) {
                if (this.wip == this.maxConcurrency) {
                    this.sources.offer(p2);
                    return;
                }
                ++this.wip;
            }
        }
        this.subscribeInner(p2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribeInner(ObservableSource<? extends U> p2) {
        block5: {
            ObservableFlatMap$InnerObserver inner;
            while (p2 instanceof Callable) {
                this.tryEmitScalar((Callable)((Object)p2));
                if (this.maxConcurrency == Integer.MAX_VALUE) break block5;
                ObservableFlatMap$MergeObserver observableFlatMap$MergeObserver = this;
                synchronized (observableFlatMap$MergeObserver) {
                    p2 = this.sources.poll();
                    if (p2 == null) {
                        --this.wip;
                        break block5;
                    }
                }
            }
            if (!this.addInner(inner = new ObservableFlatMap$InnerObserver(this, this.uniqueId++))) break block5;
            p2.subscribe(inner);
        }
    }

    boolean addInner(ObservableFlatMap$InnerObserver<T, U> inner) {
        ObservableFlatMap$InnerObserver[] b2;
        ObservableFlatMap$InnerObserver<?, ?>[] a2;
        do {
            if ((a2 = this.observers.get()) == CANCELLED) {
                inner.dispose();
                return false;
            }
            int n2 = a2.length;
            b2 = new ObservableFlatMap$InnerObserver[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = inner;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    void removeInner(ObservableFlatMap$InnerObserver<T, U> inner) {
        ObservableFlatMap$InnerObserver<?, ?>[] b2;
        ObservableFlatMap$InnerObserver<?, ?>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != inner) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new ObservableFlatMap$InnerObserver[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }

    void tryEmitScalar(Callable<? extends U> value) {
        U u2;
        try {
            u2 = value.call();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.errors.addThrowable(ex2);
            this.drain();
            return;
        }
        if (u2 == null) {
            return;
        }
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            this.actual.onNext(u2);
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SimplePlainQueue<U> q2 = this.queue;
            if (q2 == null) {
                q2 = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                this.queue = q2;
            }
            if (!q2.offer(u2)) {
                this.onError(new IllegalStateException("Scalar queue full?!"));
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    void tryEmit(U value, ObservableFlatMap$InnerObserver<T, U> inner) {
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            this.actual.onNext(value);
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SimpleQueue q2 = inner.queue;
            if (q2 == null) {
                q2 = new SpscLinkedArrayQueue(this.bufferSize);
                inner.queue = q2;
            }
            q2.offer(value);
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        if (this.errors.addThrowable(t2)) {
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            Throwable ex2;
            this.cancelled = true;
            if (this.disposeAll() && (ex2 = this.errors.terminate()) != null && ex2 != ExceptionHelper.TERMINATED) {
                RxJavaPlugins.onError(ex2);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void drain() {
        if (this.getAndIncrement() == 0) {
            this.drainLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drainLoop() {
        Observer<U> child = this.actual;
        int missed = 1;
        while (true) {
            if (this.checkTerminate()) {
                return;
            }
            SimplePlainQueue<U> svq = this.queue;
            if (svq != null) {
                while (true) {
                    if (this.checkTerminate()) {
                        return;
                    }
                    U o2 = svq.poll();
                    if (o2 != null) {
                        child.onNext(o2);
                        continue;
                    }
                    if (o2 == null) break;
                }
            }
            boolean d2 = this.done;
            svq = this.queue;
            ObservableFlatMap$InnerObserver<?, ?>[] inner = this.observers.get();
            int n2 = inner.length;
            if (d2 && (svq == null || svq.isEmpty()) && n2 == 0) {
                Throwable ex2 = this.errors.terminate();
                if (ex2 != ExceptionHelper.TERMINATED) {
                    if (ex2 == null) {
                        child.onComplete();
                    } else {
                        child.onError(ex2);
                    }
                }
                return;
            }
            boolean innerCompleted = false;
            if (n2 != 0) {
                int i2;
                int j2;
                long startId = this.lastId;
                int index = this.lastIndex;
                if (n2 <= index || inner[index].id != startId) {
                    if (n2 <= index) {
                        index = 0;
                    }
                    j2 = index;
                    for (i2 = 0; i2 < n2 && inner[j2].id != startId; ++i2) {
                        if (++j2 != n2) continue;
                        j2 = 0;
                    }
                    index = j2;
                    this.lastIndex = j2;
                    this.lastId = inner[j2].id;
                }
                j2 = index;
                block8: for (i2 = 0; i2 < n2; ++i2) {
                    Object o3;
                    if (this.checkTerminate()) {
                        return;
                    }
                    ObservableFlatMap$InnerObserver<?, ?> is2 = inner[j2];
                    block9: do {
                        if (this.checkTerminate()) {
                            return;
                        }
                        SimpleQueue q2 = is2.queue;
                        if (q2 == null) break;
                        do {
                            try {
                                o3 = q2.poll();
                            }
                            catch (Throwable ex3) {
                                Exceptions.throwIfFatal(ex3);
                                is2.dispose();
                                this.errors.addThrowable(ex3);
                                if (this.checkTerminate()) {
                                    return;
                                }
                                this.removeInner(is2);
                                innerCompleted = true;
                                ++i2;
                                continue block8;
                            }
                            if (o3 == null) continue block9;
                            child.onNext(o3);
                        } while (!this.checkTerminate());
                        return;
                    } while (o3 != null);
                    boolean innerDone = is2.done;
                    SimpleQueue innerQueue = is2.queue;
                    if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                        this.removeInner(is2);
                        if (this.checkTerminate()) {
                            return;
                        }
                        innerCompleted = true;
                    }
                    if (++j2 != n2) continue;
                    j2 = 0;
                }
                this.lastIndex = j2;
                this.lastId = inner[j2].id;
            }
            if (innerCompleted) {
                ObservableSource<? extends U> p2;
                if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                ObservableFlatMap$MergeObserver observableFlatMap$MergeObserver = this;
                synchronized (observableFlatMap$MergeObserver) {
                    p2 = this.sources.poll();
                    if (p2 == null) {
                        --this.wip;
                        continue;
                    }
                }
                this.subscribeInner(p2);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }

    boolean checkTerminate() {
        if (this.cancelled) {
            return true;
        }
        Throwable e2 = (Throwable)this.errors.get();
        if (!this.delayErrors && e2 != null) {
            this.disposeAll();
            e2 = this.errors.terminate();
            if (e2 != ExceptionHelper.TERMINATED) {
                this.actual.onError(e2);
            }
            return true;
        }
        return false;
    }

    boolean disposeAll() {
        this.s.dispose();
        ObservableFlatMap$InnerObserver<?, ?>[] a2 = this.observers.get();
        if (a2 != CANCELLED && (a2 = this.observers.getAndSet(CANCELLED)) != CANCELLED) {
            for (ObservableFlatMap$InnerObserver<?, ?> inner : a2) {
                inner.dispose();
            }
            return true;
        }
        return false;
    }
}

