/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableFlatMapSingle$FlatMapSingleObserver$InnerObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableFlatMapSingle$FlatMapSingleObserver<T, R>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = 8600231336733376951L;
    final Observer<? super R> actual;
    final boolean delayErrors;
    final CompositeDisposable set;
    final AtomicInteger active;
    final AtomicThrowable errors;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final AtomicReference<SpscLinkedArrayQueue<R>> queue;
    Disposable d;
    volatile boolean cancelled;

    ObservableFlatMapSingle$FlatMapSingleObserver(Observer<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayErrors) {
        this.actual = actual;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.set = new CompositeDisposable();
        this.errors = new AtomicThrowable();
        this.active = new AtomicInteger(1);
        this.queue = new AtomicReference();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        SingleSource<R> ms2;
        try {
            ms2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null SingleSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.d.dispose();
            this.onError(ex2);
            return;
        }
        this.active.getAndIncrement();
        ObservableFlatMapSingle$FlatMapSingleObserver$InnerObserver inner = new ObservableFlatMapSingle$FlatMapSingleObserver$InnerObserver(this);
        if (!this.cancelled && this.set.add(inner)) {
            ms2.subscribe(inner);
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.active.decrementAndGet();
        if (this.errors.addThrowable(t2)) {
            if (!this.delayErrors) {
                this.set.dispose();
            }
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        this.active.decrementAndGet();
        this.drain();
    }

    @Override
    public void dispose() {
        this.cancelled = true;
        this.d.dispose();
        this.set.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void innerSuccess(ObservableFlatMapSingle$FlatMapSingleObserver$InnerObserver inner, R value) {
        this.set.delete(inner);
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            this.actual.onNext(value);
            boolean d2 = this.active.decrementAndGet() == 0;
            SpscLinkedArrayQueue<R> q2 = this.queue.get();
            if (d2 && (q2 == null || q2.isEmpty())) {
                Throwable ex2 = this.errors.terminate();
                if (ex2 != null) {
                    this.actual.onError(ex2);
                } else {
                    this.actual.onComplete();
                }
                return;
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SpscLinkedArrayQueue<R> q3;
            SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q3 = this.getOrCreateQueue();
            synchronized (spscLinkedArrayQueue) {
                q3.offer(value);
            }
            this.active.decrementAndGet();
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    SpscLinkedArrayQueue<R> getOrCreateQueue() {
        SpscLinkedArrayQueue<Object> current;
        do {
            if ((current = this.queue.get()) == null) continue;
            return current;
        } while (!this.queue.compareAndSet(null, current = new SpscLinkedArrayQueue(Observable.bufferSize())));
        return current;
    }

    void innerError(ObservableFlatMapSingle$FlatMapSingleObserver$InnerObserver inner, Throwable e2) {
        this.set.delete(inner);
        if (this.errors.addThrowable(e2)) {
            if (!this.delayErrors) {
                this.d.dispose();
                this.set.dispose();
            }
            this.active.decrementAndGet();
            this.drain();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    void drain() {
        if (this.getAndIncrement() == 0) {
            this.drainLoop();
        }
    }

    void clear() {
        SpscLinkedArrayQueue<R> q2 = this.queue.get();
        if (q2 != null) {
            q2.clear();
        }
    }

    void drainLoop() {
        int missed = 1;
        Observer<R> a2 = this.actual;
        AtomicInteger n2 = this.active;
        AtomicReference<SpscLinkedArrayQueue<R>> qr2 = this.queue;
        while (true) {
            boolean empty;
            Throwable ex2;
            if (this.cancelled) {
                this.clear();
                return;
            }
            if (!this.delayErrors && (ex2 = (Throwable)this.errors.get()) != null) {
                ex2 = this.errors.terminate();
                this.clear();
                a2.onError(ex2);
                return;
            }
            boolean d2 = n2.get() == 0;
            SpscLinkedArrayQueue<R> q2 = qr2.get();
            Object v2 = q2 != null ? (Object)q2.poll() : null;
            boolean bl2 = empty = v2 == null;
            if (d2 && empty) {
                Throwable ex3 = this.errors.terminate();
                if (ex3 != null) {
                    a2.onError(ex3);
                } else {
                    a2.onComplete();
                }
                return;
            }
            if (!empty) {
                a2.onNext(v2);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }
}

