/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.DeferredScalarDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class ObservableFromCallable<T>
extends Observable<T>
implements Callable<T> {
    final Callable<? extends T> callable;

    public ObservableFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        T value;
        DeferredScalarDisposable<T> d2 = new DeferredScalarDisposable<T>(s2);
        s2.onSubscribe(d2);
        if (d2.isDisposed()) {
            return;
        }
        try {
            value = ObjectHelper.requireNonNull(this.callable.call(), "Callable returned null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            if (!d2.isDisposed()) {
                s2.onError(e2);
            } else {
                RxJavaPlugins.onError(e2);
            }
            return;
        }
        d2.complete(value);
    }

    @Override
    public T call() {
        return ObjectHelper.requireNonNull(this.callable.call(), "The callable returned a null value");
    }
}

