/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.ObservableFromIterable$FromIterableDisposable;
import java.util.Iterator;

public final class ObservableFromIterable<T>
extends Observable<T> {
    final Iterable<? extends T> source;

    public ObservableFromIterable(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        boolean hasNext;
        Iterator<T> it2;
        try {
            it2 = this.source.iterator();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptyDisposable.error(e2, s2);
            return;
        }
        try {
            hasNext = it2.hasNext();
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            EmptyDisposable.error(e3, s2);
            return;
        }
        if (!hasNext) {
            EmptyDisposable.complete(s2);
            return;
        }
        ObservableFromIterable$FromIterableDisposable<T> d2 = new ObservableFromIterable$FromIterableDisposable<T>(s2, it2);
        s2.onSubscribe(d2);
        if (!d2.fusionMode) {
            d2.run();
        }
    }
}

