/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Emitter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableGenerate$GeneratorDisposable<T, S>
implements Emitter<T>,
Disposable {
    final Observer<? super T> actual;
    final BiFunction<S, ? super Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;
    S state;
    volatile boolean cancelled;
    boolean terminate;
    boolean hasNext;

    ObservableGenerate$GeneratorDisposable(Observer<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
        this.actual = actual;
        this.generator = generator;
        this.disposeState = disposeState;
        this.state = initialState;
    }

    public void run() {
        S s2 = this.state;
        if (this.cancelled) {
            this.state = null;
            this.dispose(s2);
            return;
        }
        BiFunction<S, Emitter<T>, S> f2 = this.generator;
        do {
            if (this.cancelled) {
                this.state = null;
                this.dispose(s2);
                return;
            }
            this.hasNext = false;
            try {
                s2 = f2.apply(s2, this);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.state = null;
                this.cancelled = true;
                this.onError(ex2);
                this.dispose(s2);
                return;
            }
        } while (!this.terminate);
        this.cancelled = true;
        this.state = null;
        this.dispose(s2);
    }

    private void dispose(S s2) {
        try {
            this.disposeState.accept(s2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    @Override
    public void onNext(T t2) {
        if (!this.terminate) {
            if (this.hasNext) {
                this.onError(new IllegalStateException("onNext already called in this generate turn"));
            } else if (t2 == null) {
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            } else {
                this.hasNext = true;
                this.actual.onNext(t2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.terminate) {
            RxJavaPlugins.onError(t2);
        } else {
            if (t2 == null) {
                t2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
            }
            this.terminate = true;
            this.actual.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.terminate) {
            this.terminate = true;
            this.actual.onComplete();
        }
    }
}

