/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Emitter;
import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.SingleSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$BufferedReplayCallable;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$BufferedTimedReplayCallable;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$FlatMapIntoIterable;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$FlatMapWithCombinerOuter;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ItemDelayFunction;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ObservableMapper;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ObserverOnComplete;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ObserverOnError;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ObserverOnNext;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$RepeatWhenOuterHandler;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ReplayCallable;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ReplayFunction;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$RetryWhenInner;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$SimpleBiGenerator;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$SimpleGenerator;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$TimedReplayCallable;
import io.reactivex.internal.operators.observable.ObservableInternalHelper$ZipIterableFunction;
import io.reactivex.observables.ConnectableObservable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class ObservableInternalHelper {
    private ObservableInternalHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, S> BiFunction<S, Emitter<T>, S> simpleGenerator(Consumer<Emitter<T>> consumer) {
        return new ObservableInternalHelper$SimpleGenerator(consumer);
    }

    public static <T, S> BiFunction<S, Emitter<T>, S> simpleBiGenerator(BiConsumer<S, Emitter<T>> consumer) {
        return new ObservableInternalHelper$SimpleBiGenerator<T, S>(consumer);
    }

    public static <T, U> Function<T, ObservableSource<T>> itemDelay(Function<? super T, ? extends ObservableSource<U>> itemDelay) {
        return new ObservableInternalHelper$ItemDelayFunction(itemDelay);
    }

    public static <T> Consumer<T> observerOnNext(Observer<T> observer) {
        return new ObservableInternalHelper$ObserverOnNext<T>(observer);
    }

    public static <T> Consumer<Throwable> observerOnError(Observer<T> observer) {
        return new ObservableInternalHelper$ObserverOnError<T>(observer);
    }

    public static <T> Action observerOnComplete(Observer<T> observer) {
        return new ObservableInternalHelper$ObserverOnComplete<T>(observer);
    }

    public static <T, U, R> Function<T, ObservableSource<R>> flatMapWithCombiner(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner) {
        return new ObservableInternalHelper$FlatMapWithCombinerOuter<T, R, U>(combiner, mapper);
    }

    public static <T, U> Function<T, ObservableSource<U>> flatMapIntoIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return new ObservableInternalHelper$FlatMapIntoIterable(mapper);
    }

    public static Function<Observable<Notification<Object>>, ObservableSource<?>> repeatWhenHandler(Function<? super Observable<Object>, ? extends ObservableSource<?>> handler) {
        return new ObservableInternalHelper$RepeatWhenOuterHandler(handler);
    }

    public static <T> Callable<ConnectableObservable<T>> replayCallable(Observable<T> parent) {
        return new ObservableInternalHelper$ReplayCallable<T>(parent);
    }

    public static <T> Callable<ConnectableObservable<T>> replayCallable(Observable<T> parent, int bufferSize) {
        return new ObservableInternalHelper$BufferedReplayCallable<T>(parent, bufferSize);
    }

    public static <T> Callable<ConnectableObservable<T>> replayCallable(Observable<T> parent, int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        return new ObservableInternalHelper$BufferedTimedReplayCallable<T>(parent, bufferSize, time, unit, scheduler);
    }

    public static <T> Callable<ConnectableObservable<T>> replayCallable(Observable<T> parent, long time, TimeUnit unit, Scheduler scheduler) {
        return new ObservableInternalHelper$TimedReplayCallable<T>(parent, time, unit, scheduler);
    }

    public static <T, R> Function<Observable<T>, ObservableSource<R>> replayFunction(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, Scheduler scheduler) {
        return new ObservableInternalHelper$ReplayFunction(selector, scheduler);
    }

    public static <T> Function<Observable<Notification<Object>>, ObservableSource<?>> retryWhenHandler(Function<? super Observable<Throwable>, ? extends ObservableSource<?>> handler) {
        return new ObservableInternalHelper$RetryWhenInner(handler);
    }

    public static <T, R> Function<List<ObservableSource<? extends T>>, ObservableSource<? extends R>> zipIterable(Function<? super Object[], ? extends R> zipper) {
        return new ObservableInternalHelper$ZipIterableFunction(zipper);
    }

    public static <T, R> Observable<R> switchMapSingle(Observable<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return source.switchMap(ObservableInternalHelper.convertSingleMapperToObservableMapper(mapper), 1);
    }

    public static <T, R> Observable<R> switchMapSingleDelayError(Observable<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return source.switchMapDelayError(ObservableInternalHelper.convertSingleMapperToObservableMapper(mapper), 1);
    }

    private static <T, R> Function<T, Observable<R>> convertSingleMapperToObservableMapper(Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return new ObservableInternalHelper$ObservableMapper(mapper);
    }
}

