/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableGroupJoin$JoinSupport;
import io.reactivex.internal.operators.observable.ObservableGroupJoin$LeftRightEndObserver;
import io.reactivex.internal.operators.observable.ObservableGroupJoin$LeftRightObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableJoin$JoinDisposable<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AtomicInteger
implements Disposable,
ObservableGroupJoin$JoinSupport {
    private static final long serialVersionUID = -6071216598687999801L;
    final Observer<? super R> actual;
    final SpscLinkedArrayQueue<Object> queue;
    final CompositeDisposable disposables;
    final Map<Integer, TLeft> lefts;
    final Map<Integer, TRight> rights;
    final AtomicReference<Throwable> error;
    final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;
    final AtomicInteger active;
    int leftIndex;
    int rightIndex;
    volatile boolean cancelled;
    static final Integer LEFT_VALUE = 1;
    static final Integer RIGHT_VALUE = 2;
    static final Integer LEFT_CLOSE = 3;
    static final Integer RIGHT_CLOSE = 4;

    ObservableJoin$JoinDisposable(Observer<? super R> actual, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector) {
        this.actual = actual;
        this.disposables = new CompositeDisposable();
        this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
        this.lefts = new LinkedHashMap<Integer, TLeft>();
        this.rights = new LinkedHashMap<Integer, TRight>();
        this.error = new AtomicReference();
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
        this.active = new AtomicInteger(2);
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void cancelAll() {
        this.disposables.dispose();
    }

    void errorAll(Observer<?> a2) {
        Throwable ex2 = ExceptionHelper.terminate(this.error);
        this.lefts.clear();
        this.rights.clear();
        a2.onError(ex2);
    }

    void fail(Throwable exc, Observer<?> a2, SpscLinkedArrayQueue<?> q2) {
        Exceptions.throwIfFatal(exc);
        ExceptionHelper.addThrowable(this.error, exc);
        q2.clear();
        this.cancelAll();
        this.errorAll(a2);
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        Observer<R> a2 = this.actual;
        block8: while (true) {
            boolean empty;
            if (this.cancelled) {
                q2.clear();
                return;
            }
            Throwable ex2 = this.error.get();
            if (ex2 != null) {
                q2.clear();
                this.cancelAll();
                this.errorAll(a2);
                return;
            }
            boolean d2 = this.active.get() == 0;
            Integer mode = (Integer)q2.poll();
            boolean bl2 = empty = mode == null;
            if (d2 && empty) {
                this.lefts.clear();
                this.rights.clear();
                this.disposables.dispose();
                a2.onComplete();
                return;
            }
            if (!empty) {
                ObservableGroupJoin$LeftRightEndObserver end;
                R w2;
                Iterator<Object> iterator;
                ObservableGroupJoin$LeftRightEndObserver end2;
                ObservableSource<Object> p2;
                int idx;
                Object val = q2.poll();
                if (mode == LEFT_VALUE) {
                    Object left = val;
                    ++this.leftIndex;
                    this.lefts.put(idx, left);
                    try {
                        p2 = ObjectHelper.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null ObservableSource");
                    }
                    catch (Throwable exc) {
                        this.fail(exc, a2, q2);
                        return;
                    }
                    end2 = new ObservableGroupJoin$LeftRightEndObserver(this, true, idx);
                    this.disposables.add(end2);
                    p2.subscribe(end2);
                    ex2 = this.error.get();
                    if (ex2 != null) {
                        q2.clear();
                        this.cancelAll();
                        this.errorAll(a2);
                        return;
                    }
                    iterator = this.rights.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block8;
                        Object right = iterator.next();
                        try {
                            w2 = ObjectHelper.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        a2.onNext(w2);
                    }
                }
                if (mode == RIGHT_VALUE) {
                    Object right = val;
                    ++this.rightIndex;
                    this.rights.put(idx, right);
                    try {
                        p2 = ObjectHelper.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null ObservableSource");
                    }
                    catch (Throwable exc) {
                        this.fail(exc, a2, q2);
                        return;
                    }
                    end2 = new ObservableGroupJoin$LeftRightEndObserver(this, false, idx);
                    this.disposables.add(end2);
                    p2.subscribe(end2);
                    ex2 = this.error.get();
                    if (ex2 != null) {
                        q2.clear();
                        this.cancelAll();
                        this.errorAll(a2);
                        return;
                    }
                    iterator = this.lefts.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block8;
                        Object left = iterator.next();
                        try {
                            w2 = ObjectHelper.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        a2.onNext(w2);
                    }
                }
                if (mode == LEFT_CLOSE) {
                    end = (ObservableGroupJoin$LeftRightEndObserver)val;
                    this.lefts.remove(end.index);
                    this.disposables.remove(end);
                    continue;
                }
                end = (ObservableGroupJoin$LeftRightEndObserver)val;
                this.rights.remove(end.index);
                this.disposables.remove(end);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public void innerError(Throwable ex2) {
        if (ExceptionHelper.addThrowable(this.error, ex2)) {
            this.active.decrementAndGet();
            this.drain();
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    @Override
    public void innerComplete(ObservableGroupJoin$LeftRightObserver sender) {
        this.disposables.delete(sender);
        this.active.decrementAndGet();
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void innerValue(boolean isLeft, Object o2) {
        ObservableJoin$JoinDisposable observableJoin$JoinDisposable = this;
        synchronized (observableJoin$JoinDisposable) {
            this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o2);
        }
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void innerClose(boolean isLeft, ObservableGroupJoin$LeftRightEndObserver index) {
        ObservableJoin$JoinDisposable observableJoin$JoinDisposable = this;
        synchronized (observableJoin$JoinDisposable) {
            this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
        }
        this.drain();
    }

    @Override
    public void innerCloseError(Throwable ex2) {
        if (ExceptionHelper.addThrowable(this.error, ex2)) {
            this.drain();
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }
}

