/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableObserveOn$ObserveOnObserver<T>
extends BasicIntQueueDisposable<T>
implements Observer<T>,
Runnable {
    private static final long serialVersionUID = 6576896619930983584L;
    final Observer<? super T> actual;
    final Scheduler$Worker worker;
    final boolean delayError;
    final int bufferSize;
    SimpleQueue<T> queue;
    Disposable s;
    Throwable error;
    volatile boolean done;
    volatile boolean cancelled;
    int sourceMode;
    boolean outputFused;

    ObservableObserveOn$ObserveOnObserver(Observer<? super T> actual, Scheduler$Worker worker, boolean delayError, int bufferSize) {
        this.actual = actual;
        this.worker = worker;
        this.delayError = delayError;
        this.bufferSize = bufferSize;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueDisposable) {
                QueueDisposable qd2 = (QueueDisposable)s2;
                int m2 = qd2.requestFusion(7);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = qd2;
                    this.done = true;
                    this.actual.onSubscribe(this);
                    this.schedule();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = qd2;
                    this.actual.onSubscribe(this);
                    return;
                }
            }
            this.queue = new SpscLinkedArrayQueue(this.bufferSize);
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.sourceMode != 2) {
            this.queue.offer(t2);
        }
        this.schedule();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.schedule();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.schedule();
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.dispose();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void schedule() {
        if (this.getAndIncrement() == 0) {
            this.worker.schedule(this);
        }
    }

    void drainNormal() {
        int missed = 1;
        SimpleQueue<T> q2 = this.queue;
        Observer<T> a2 = this.actual;
        block2: do {
            if (this.checkTerminated(this.done, q2.isEmpty(), a2)) {
                return;
            }
            while (true) {
                boolean empty;
                T v2;
                boolean d2 = this.done;
                try {
                    v2 = q2.poll();
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.s.dispose();
                    q2.clear();
                    a2.onError(ex2);
                    this.worker.dispose();
                    return;
                }
                boolean bl2 = empty = v2 == null;
                if (this.checkTerminated(d2, empty, a2)) {
                    return;
                }
                if (empty) continue block2;
                a2.onNext(v2);
            }
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    void drainFused() {
        int missed = 1;
        do {
            if (this.cancelled) {
                return;
            }
            boolean d2 = this.done;
            Throwable ex2 = this.error;
            if (!this.delayError && d2 && ex2 != null) {
                this.actual.onError(this.error);
                this.worker.dispose();
                return;
            }
            this.actual.onNext(null);
            if (!d2) continue;
            ex2 = this.error;
            if (ex2 != null) {
                this.actual.onError(ex2);
            } else {
                this.actual.onComplete();
            }
            this.worker.dispose();
            return;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    @Override
    public void run() {
        if (this.outputFused) {
            this.drainFused();
        } else {
            this.drainNormal();
        }
    }

    boolean checkTerminated(boolean d2, boolean empty, Observer<? super T> a2) {
        if (this.cancelled) {
            this.queue.clear();
            return true;
        }
        if (d2) {
            Throwable e2 = this.error;
            if (this.delayError) {
                if (empty) {
                    if (e2 != null) {
                        a2.onError(e2);
                    } else {
                        a2.onComplete();
                    }
                    this.worker.dispose();
                    return true;
                }
            } else {
                if (e2 != null) {
                    this.queue.clear();
                    a2.onError(e2);
                    this.worker.dispose();
                    return true;
                }
                if (empty) {
                    a2.onComplete();
                    this.worker.dispose();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    @Nullable
    public T poll() {
        return this.queue.poll();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

