/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableOnErrorNext$OnErrorNextObserver<T>
implements Observer<T> {
    final Observer<? super T> actual;
    final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;
    final boolean allowFatal;
    final SequentialDisposable arbiter;
    boolean once;
    boolean done;

    ObservableOnErrorNext$OnErrorNextObserver(Observer<? super T> actual, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier, boolean allowFatal) {
        this.actual = actual;
        this.nextSupplier = nextSupplier;
        this.allowFatal = allowFatal;
        this.arbiter = new SequentialDisposable();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        this.arbiter.replace(s2);
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        ObservableSource<T> p2;
        if (this.once) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.actual.onError(t2);
            return;
        }
        this.once = true;
        if (this.allowFatal && !(t2 instanceof Exception)) {
            this.actual.onError(t2);
            return;
        }
        try {
            p2 = this.nextSupplier.apply(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(new CompositeException(t2, e2));
            return;
        }
        if (p2 == null) {
            NullPointerException npe = new NullPointerException("Observable is null");
            npe.initCause(t2);
            this.actual.onError(npe);
            return;
        }
        p2.subscribe(this);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.once = true;
        this.actual.onComplete();
    }
}

