/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;

final class ObservableOnErrorReturn$OnErrorReturnObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final Function<? super Throwable, ? extends T> valueSupplier;
    Disposable s;

    ObservableOnErrorReturn$OnErrorReturnObserver(Observer<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
        this.actual = actual;
        this.valueSupplier = valueSupplier;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        T v2;
        try {
            v2 = this.valueSupplier.apply(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(new CompositeException(t2, e2));
            return;
        }
        if (v2 == null) {
            NullPointerException e3 = new NullPointerException("The supplied value is null");
            e3.initCause(t2);
            this.actual.onError(e3);
            return;
        }
        this.actual.onNext(v2);
        this.actual.onComplete();
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }
}

