/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservablePublishSelector$SourceObserver;
import io.reactivex.internal.operators.observable.ObservablePublishSelector$TargetObserver;
import io.reactivex.subjects.PublishSubject;

public final class ObservablePublishSelector<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super Observable<T>, ? extends ObservableSource<R>> selector;

    public ObservablePublishSelector(ObservableSource<T> source, Function<? super Observable<T>, ? extends ObservableSource<R>> selector) {
        super(source);
        this.selector = selector;
    }

    @Override
    public void subscribeActual(Observer<? super R> observer) {
        ObservableSource<R> target;
        PublishSubject subject = PublishSubject.create();
        try {
            target = ObjectHelper.requireNonNull(this.selector.apply(subject), "The selector returned a null ObservableSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptyDisposable.error(ex2, observer);
            return;
        }
        ObservablePublishSelector$TargetObserver o2 = new ObservablePublishSelector$TargetObserver(observer);
        target.subscribe(o2);
        this.source.subscribe(new ObservablePublishSelector$SourceObserver(subject, o2));
    }
}

