/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.MaybeObserver;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableReduceMaybe$ReduceObserver<T>
implements Observer<T>,
Disposable {
    final MaybeObserver<? super T> actual;
    final BiFunction<T, T, T> reducer;
    boolean done;
    T value;
    Disposable d;

    ObservableReduceMaybe$ReduceObserver(MaybeObserver<? super T> observer, BiFunction<T, T, T> reducer) {
        this.actual = observer;
        this.reducer = reducer;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T value) {
        if (!this.done) {
            T v2 = this.value;
            if (v2 == null) {
                this.value = value;
            } else {
                try {
                    this.value = ObjectHelper.requireNonNull(this.reducer.apply(v2, value), "The reducer returned a null value");
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.d.dispose();
                    this.onError(ex2);
                }
            }
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (this.done) {
            RxJavaPlugins.onError(e2);
            return;
        }
        this.done = true;
        this.value = null;
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        T v2 = this.value;
        this.value = null;
        if (v2 != null) {
            this.actual.onSuccess(v2);
        } else {
            this.actual.onComplete();
        }
    }

    @Override
    public void dispose() {
        this.d.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }
}

