/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableReduceSeedSingle$ReduceSeedObserver<T, R>
implements Observer<T>,
Disposable {
    final SingleObserver<? super R> actual;
    final BiFunction<R, ? super T, R> reducer;
    R value;
    Disposable d;

    ObservableReduceSeedSingle$ReduceSeedObserver(SingleObserver<? super R> actual, BiFunction<R, ? super T, R> reducer, R value) {
        this.actual = actual;
        this.value = value;
        this.reducer = reducer;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T value) {
        R v2 = this.value;
        if (v2 != null) {
            try {
                this.value = ObjectHelper.requireNonNull(this.reducer.apply(v2, value), "The reducer returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.d.dispose();
                this.onError(ex2);
            }
        }
    }

    @Override
    public void onError(Throwable e2) {
        R v2 = this.value;
        this.value = null;
        if (v2 != null) {
            this.actual.onError(e2);
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        R v2 = this.value;
        this.value = null;
        if (v2 != null) {
            this.actual.onSuccess(v2);
        }
    }

    @Override
    public void dispose() {
        this.d.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }
}

