/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.internal.operators.observable.ObservableReplay$InnerDisposable;
import io.reactivex.internal.operators.observable.ObservableReplay$Node;
import io.reactivex.internal.operators.observable.ObservableReplay$ReplayBuffer;
import io.reactivex.internal.util.NotificationLite;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

abstract class ObservableReplay$BoundedReplayBuffer<T>
extends AtomicReference<ObservableReplay$Node>
implements ObservableReplay$ReplayBuffer<T> {
    private static final long serialVersionUID = 2346567790059478686L;
    ObservableReplay$Node tail;
    int size;

    ObservableReplay$BoundedReplayBuffer() {
        ObservableReplay$Node n2;
        this.tail = n2 = new ObservableReplay$Node((Object)null);
        this.set(n2);
    }

    final void addLast(ObservableReplay$Node n2) {
        this.tail.set(n2);
        this.tail = n2;
        ++this.size;
    }

    final void removeFirst() {
        ObservableReplay$Node head = (ObservableReplay$Node)this.get();
        ObservableReplay$Node next = (ObservableReplay$Node)head.get();
        --this.size;
        this.setFirst(next);
    }

    final void removeSome(int n2) {
        ObservableReplay$Node head = (ObservableReplay$Node)this.get();
        while (n2 > 0) {
            head = (ObservableReplay$Node)head.get();
            --n2;
            --this.size;
        }
        this.setFirst(head);
    }

    final void setFirst(ObservableReplay$Node n2) {
        this.set(n2);
    }

    @Override
    public final void next(T value) {
        Object o2 = this.enterTransform(NotificationLite.next(value));
        ObservableReplay$Node n2 = new ObservableReplay$Node(o2);
        this.addLast(n2);
        this.truncate();
    }

    @Override
    public final void error(Throwable e2) {
        Object o2 = this.enterTransform(NotificationLite.error(e2));
        ObservableReplay$Node n2 = new ObservableReplay$Node(o2);
        this.addLast(n2);
        this.truncateFinal();
    }

    @Override
    public final void complete() {
        Object o2 = this.enterTransform(NotificationLite.complete());
        ObservableReplay$Node n2 = new ObservableReplay$Node(o2);
        this.addLast(n2);
        this.truncateFinal();
    }

    @Override
    public final void replay(ObservableReplay$InnerDisposable<T> output) {
        if (output.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            ObservableReplay$Node node;
            if ((node = (ObservableReplay$Node)output.index()) == null) {
                node = this.getHead();
                output.index = node;
            }
            while (true) {
                if (output.isDisposed()) {
                    return;
                }
                ObservableReplay$Node v2 = (ObservableReplay$Node)node.get();
                if (v2 == null) break;
                Object o2 = this.leaveTransform(v2.value);
                if (NotificationLite.accept(o2, output.child)) {
                    output.index = null;
                    return;
                }
                node = v2;
            }
            output.index = node;
        } while ((missed = output.addAndGet(-missed)) != 0);
    }

    Object enterTransform(Object value) {
        return value;
    }

    Object leaveTransform(Object value) {
        return value;
    }

    abstract void truncate();

    void truncateFinal() {
    }

    final void collect(Collection<? super T> output) {
        Object o2;
        Object v2;
        ObservableReplay$Node next;
        ObservableReplay$Node n2 = this.getHead();
        while ((next = (ObservableReplay$Node)n2.get()) != null && !NotificationLite.isComplete(v2 = this.leaveTransform(o2 = next.value)) && !NotificationLite.isError(v2)) {
            output.add(NotificationLite.getValue(v2));
            n2 = next;
        }
    }

    boolean hasError() {
        return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
    }

    boolean hasCompleted() {
        return this.tail.value != null && NotificationLite.isComplete(this.leaveTransform(this.tail.value));
    }

    ObservableReplay$Node getHead() {
        return (ObservableReplay$Node)this.get();
    }
}

