/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableReplay$DisposeConsumer;
import io.reactivex.internal.operators.observable.ObserverResourceWrapper;
import io.reactivex.observables.ConnectableObservable;
import java.util.concurrent.Callable;

final class ObservableReplay$MulticastReplay<R, U>
extends Observable<R> {
    private final Callable<? extends ConnectableObservable<U>> connectableFactory;
    private final Function<? super Observable<U>, ? extends ObservableSource<R>> selector;

    ObservableReplay$MulticastReplay(Callable<? extends ConnectableObservable<U>> connectableFactory, Function<? super Observable<U>, ? extends ObservableSource<R>> selector) {
        this.connectableFactory = connectableFactory;
        this.selector = selector;
    }

    @Override
    public void subscribeActual(Observer<? super R> child) {
        ObservableSource<R> observable;
        ConnectableObservable<U> co2;
        try {
            co2 = ObjectHelper.requireNonNull(this.connectableFactory.call(), "The connectableFactory returned a null ConnectableObservable");
            observable = ObjectHelper.requireNonNull(this.selector.apply(co2), "The selector returned a null ObservableSource");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptyDisposable.error(e2, child);
            return;
        }
        ObserverResourceWrapper<? super R> srw = new ObserverResourceWrapper<R>(child);
        observable.subscribe(srw);
        co2.connect(new ObservableReplay$DisposeConsumer<R>(srw));
    }
}

