/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Scheduler;
import io.reactivex.internal.operators.observable.ObservableReplay$BoundedReplayBuffer;
import io.reactivex.internal.operators.observable.ObservableReplay$Node;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.schedulers.Timed;
import java.util.concurrent.TimeUnit;

final class ObservableReplay$SizeAndTimeBoundReplayBuffer<T>
extends ObservableReplay$BoundedReplayBuffer<T> {
    private static final long serialVersionUID = 3457957419649567404L;
    final Scheduler scheduler;
    final long maxAge;
    final TimeUnit unit;
    final int limit;

    ObservableReplay$SizeAndTimeBoundReplayBuffer(int limit, long maxAge, TimeUnit unit, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.limit = limit;
        this.maxAge = maxAge;
        this.unit = unit;
    }

    @Override
    Object enterTransform(Object value) {
        return new Timed<Object>(value, this.scheduler.now(this.unit), this.unit);
    }

    @Override
    Object leaveTransform(Object value) {
        return ((Timed)value).value();
    }

    @Override
    void truncate() {
        long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
        ObservableReplay$Node prev = (ObservableReplay$Node)this.get();
        ObservableReplay$Node next = (ObservableReplay$Node)prev.get();
        int e2 = 0;
        while (next != null) {
            if (this.size > this.limit) {
                ++e2;
                --this.size;
                prev = next;
                next = (ObservableReplay$Node)next.get();
                continue;
            }
            Timed v2 = (Timed)next.value;
            if (v2.time() > timeLimit) break;
            ++e2;
            --this.size;
            prev = next;
            next = (ObservableReplay$Node)next.get();
        }
        if (e2 != 0) {
            this.setFirst(prev);
        }
    }

    @Override
    void truncateFinal() {
        Timed v2;
        long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
        ObservableReplay$Node prev = (ObservableReplay$Node)this.get();
        int e2 = 0;
        for (ObservableReplay$Node next = (ObservableReplay$Node)prev.get(); next != null && this.size > 1 && (v2 = (Timed)next.value).time() <= timeLimit; next = (ObservableReplay$Node)next.get()) {
            ++e2;
            --this.size;
            prev = next;
        }
        if (e2 != 0) {
            this.setFirst(prev);
        }
    }

    @Override
    ObservableReplay$Node getHead() {
        Timed v2;
        long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
        ObservableReplay$Node prev = (ObservableReplay$Node)this.get();
        for (ObservableReplay$Node next = (ObservableReplay$Node)prev.get(); next != null && !NotificationLite.isComplete((v2 = (Timed)next.value).value()) && !NotificationLite.isError(v2.value()) && v2.time() <= timeLimit; next = (ObservableReplay$Node)next.get()) {
            prev = next;
        }
        return prev;
    }
}

