/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.internal.operators.observable.ObservableReplay$BufferSupplier;
import io.reactivex.internal.operators.observable.ObservableReplay$MulticastReplay;
import io.reactivex.internal.operators.observable.ObservableReplay$Replay;
import io.reactivex.internal.operators.observable.ObservableReplay$ReplayBuffer;
import io.reactivex.internal.operators.observable.ObservableReplay$ReplayBufferSupplier;
import io.reactivex.internal.operators.observable.ObservableReplay$ReplayObserver;
import io.reactivex.internal.operators.observable.ObservableReplay$ReplaySource;
import io.reactivex.internal.operators.observable.ObservableReplay$ScheduledReplaySupplier;
import io.reactivex.internal.operators.observable.ObservableReplay$UnBoundedFactory;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableReplay<T>
extends ConnectableObservable<T>
implements Disposable,
HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;
    final AtomicReference<ObservableReplay$ReplayObserver<T>> current;
    final ObservableReplay$BufferSupplier<T> bufferFactory;
    final ObservableSource<T> onSubscribe;
    static final ObservableReplay$BufferSupplier DEFAULT_UNBOUNDED_FACTORY = new ObservableReplay$UnBoundedFactory();

    public static <U, R> Observable<R> multicastSelector(Callable<? extends ConnectableObservable<U>> connectableFactory, Function<? super Observable<U>, ? extends ObservableSource<R>> selector) {
        return RxJavaPlugins.onAssembly(new ObservableReplay$MulticastReplay(connectableFactory, selector));
    }

    public static <T> ConnectableObservable<T> observeOn(ConnectableObservable<T> co2, Scheduler scheduler) {
        Observable observable = co2.observeOn(scheduler);
        return RxJavaPlugins.onAssembly(new ObservableReplay$Replay<T>(co2, observable));
    }

    public static <T> ConnectableObservable<T> createFrom(ObservableSource<? extends T> source) {
        return ObservableReplay.create(source, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source, int bufferSize) {
        if (bufferSize == Integer.MAX_VALUE) {
            return ObservableReplay.createFrom(source);
        }
        return ObservableReplay.create(source, new ObservableReplay$ReplayBufferSupplier(bufferSize));
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source, long maxAge, TimeUnit unit, Scheduler scheduler) {
        return ObservableReplay.create(source, maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source, long maxAge, TimeUnit unit, Scheduler scheduler, int bufferSize) {
        return ObservableReplay.create(source, new ObservableReplay$ScheduledReplaySupplier(bufferSize, maxAge, unit, scheduler));
    }

    static <T> ConnectableObservable<T> create(ObservableSource<T> source, ObservableReplay$BufferSupplier<T> bufferFactory) {
        AtomicReference curr = new AtomicReference();
        ObservableReplay$ReplaySource onSubscribe = new ObservableReplay$ReplaySource(curr, bufferFactory);
        return RxJavaPlugins.onAssembly(new ObservableReplay(onSubscribe, source, curr, bufferFactory));
    }

    private ObservableReplay(ObservableSource<T> onSubscribe, ObservableSource<T> source, AtomicReference<ObservableReplay$ReplayObserver<T>> current, ObservableReplay$BufferSupplier<T> bufferFactory) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    @Override
    public void dispose() {
        this.current.lazySet(null);
    }

    @Override
    public boolean isDisposed() {
        Disposable d2 = this.current.get();
        return d2 == null || d2.isDisposed();
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        this.onSubscribe.subscribe(observer);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        ObservableReplay$ReplayObserver<T> ps2;
        while ((ps2 = this.current.get()) == null || ps2.isDisposed()) {
            ObservableReplay$ReplayBuffer<T> buf = this.bufferFactory.call();
            ObservableReplay$ReplayObserver<T> u2 = new ObservableReplay$ReplayObserver<T>(buf);
            if (!this.current.compareAndSet(ps2, u2)) continue;
            ps2 = u2;
            break;
        }
        boolean doConnect = !ps2.shouldConnect.get() && ps2.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps2);
        }
        catch (Throwable ex2) {
            if (doConnect) {
                ps2.shouldConnect.compareAndSet(true, false);
            }
            Exceptions.throwIfFatal(ex2);
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        if (doConnect) {
            this.source.subscribe(ps2);
        }
    }
}

