/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.disposables.SequentialDisposable;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableRetryBiPredicate$RetryBiObserver<T>
extends AtomicInteger
implements Observer<T> {
    private static final long serialVersionUID = -7098360935104053232L;
    final Observer<? super T> actual;
    final SequentialDisposable sa;
    final ObservableSource<? extends T> source;
    final BiPredicate<? super Integer, ? super Throwable> predicate;
    int retries;

    ObservableRetryBiPredicate$RetryBiObserver(Observer<? super T> actual, BiPredicate<? super Integer, ? super Throwable> predicate, SequentialDisposable sa2, ObservableSource<? extends T> source) {
        this.actual = actual;
        this.sa = sa2;
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        this.sa.update(s2);
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        boolean b2;
        try {
            b2 = this.predicate.test((Integer)(++this.retries), t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(new CompositeException(t2, e2));
            return;
        }
        if (!b2) {
            this.actual.onError(t2);
            return;
        }
        this.subscribeNext();
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }

    void subscribeNext() {
        block2: {
            if (this.getAndIncrement() != 0) break block2;
            int missed = 1;
            do {
                if (this.sa.isDisposed()) {
                    return;
                }
                this.source.subscribe(this);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

