/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

abstract class ObservableSampleTimed$SampleTimedObserver<T>
extends AtomicReference<T>
implements Observer<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = -3517602651313910099L;
    final Observer<? super T> actual;
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;
    final AtomicReference<Disposable> timer = new AtomicReference();
    Disposable s;

    ObservableSampleTimed$SampleTimedObserver(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
        this.actual = actual;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            Disposable d2 = this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit);
            DisposableHelper.replace(this.timer, d2);
        }
    }

    @Override
    public void onNext(T t2) {
        this.lazySet(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.cancelTimer();
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        this.cancelTimer();
        this.complete();
    }

    void cancelTimer() {
        DisposableHelper.dispose(this.timer);
    }

    @Override
    public void dispose() {
        this.cancelTimer();
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    void emit() {
        Object value = this.getAndSet(null);
        if (value != null) {
            this.actual.onNext(value);
        }
    }

    abstract void complete();
}

