/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.ObservableSampleWithObservable$SamplerObserver;
import java.util.concurrent.atomic.AtomicReference;

abstract class ObservableSampleWithObservable$SampleMainObserver<T>
extends AtomicReference<T>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -3517602651313910099L;
    final Observer<? super T> actual;
    final ObservableSource<?> sampler;
    final AtomicReference<Disposable> other = new AtomicReference();
    Disposable s;

    ObservableSampleWithObservable$SampleMainObserver(Observer<? super T> actual, ObservableSource<?> other) {
        this.actual = actual;
        this.sampler = other;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            if (this.other.get() == null) {
                this.sampler.subscribe(new ObservableSampleWithObservable$SamplerObserver(this));
            }
        }
    }

    @Override
    public void onNext(T t2) {
        this.lazySet(t2);
    }

    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this.other);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        DisposableHelper.dispose(this.other);
        this.completeMain();
    }

    boolean setOther(Disposable o2) {
        return DisposableHelper.setOnce(this.other, o2);
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.other);
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.other.get() == DisposableHelper.DISPOSED;
    }

    public void error(Throwable e2) {
        this.s.dispose();
        this.actual.onError(e2);
    }

    public void complete() {
        this.s.dispose();
        this.completeOther();
    }

    void emit() {
        Object value = this.getAndSet(null);
        if (value != null) {
            this.actual.onNext(value);
        }
    }

    abstract void completeMain();

    abstract void completeOther();

    abstract void run();
}

