/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableScalarXMap$ScalarDisposable;
import java.util.concurrent.Callable;

final class ObservableScalarXMap$ScalarXMapObservable<T, R>
extends Observable<R> {
    final T value;
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;

    ObservableScalarXMap$ScalarXMapObservable(T value, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        this.value = value;
        this.mapper = mapper;
    }

    @Override
    public void subscribeActual(Observer<? super R> s2) {
        ObservableSource<R> other;
        try {
            other = ObjectHelper.requireNonNull(this.mapper.apply(this.value), "The mapper returned a null ObservableSource");
        }
        catch (Throwable e2) {
            EmptyDisposable.error(e2, s2);
            return;
        }
        if (other instanceof Callable) {
            Object u2;
            try {
                u2 = ((Callable)((Object)other)).call();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptyDisposable.error(ex2, s2);
                return;
            }
            if (u2 == null) {
                EmptyDisposable.complete(s2);
                return;
            }
            ObservableScalarXMap$ScalarDisposable<R> sd2 = new ObservableScalarXMap$ScalarDisposable<R>(s2, u2);
            s2.onSubscribe(sd2);
            sd2.run();
        } else {
            other.subscribe(s2);
        }
    }
}

