/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableScalarXMap$ScalarDisposable;
import io.reactivex.internal.operators.observable.ObservableScalarXMap$ScalarXMapObservable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class ObservableScalarXMap {
    private ObservableScalarXMap() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, R> boolean tryScalarXMapSubscribe(ObservableSource<T> source, Observer<? super R> observer, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        if (source instanceof Callable) {
            ObservableSource<R> r2;
            Object t2;
            try {
                t2 = ((Callable)((Object)source)).call();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptyDisposable.error(ex2, observer);
                return true;
            }
            if (t2 == null) {
                EmptyDisposable.complete(observer);
                return true;
            }
            try {
                r2 = ObjectHelper.requireNonNull(mapper.apply(t2), "The mapper returned a null ObservableSource");
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                EmptyDisposable.error(ex3, observer);
                return true;
            }
            if (r2 instanceof Callable) {
                Object u2;
                try {
                    u2 = ((Callable)((Object)r2)).call();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    EmptyDisposable.error(ex4, observer);
                    return true;
                }
                if (u2 == null) {
                    EmptyDisposable.complete(observer);
                    return true;
                }
                ObservableScalarXMap$ScalarDisposable<R> sd2 = new ObservableScalarXMap$ScalarDisposable<R>(observer, u2);
                observer.onSubscribe(sd2);
                sd2.run();
            } else {
                r2.subscribe(observer);
            }
            return true;
        }
        return false;
    }

    public static <T, U> Observable<U> scalarXMap(T value, Function<? super T, ? extends ObservableSource<? extends U>> mapper) {
        return RxJavaPlugins.onAssembly(new ObservableScalarXMap$ScalarXMapObservable(value, mapper));
    }
}

