/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;

final class ObservableSingleSingle$SingleElementObserver<T>
implements Observer<T>,
Disposable {
    final SingleObserver<? super T> actual;
    final T defaultValue;
    Disposable s;
    T value;
    boolean done;

    ObservableSingleSingle$SingleElementObserver(SingleObserver<? super T> actual, T defaultValue) {
        this.actual = actual;
        this.defaultValue = defaultValue;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.value != null) {
            this.done = true;
            this.s.dispose();
            this.actual.onError(new IllegalArgumentException("Sequence contains more than one element!"));
            return;
        }
        this.value = t2;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        T v2 = this.value;
        this.value = null;
        if (v2 == null) {
            v2 = this.defaultValue;
        }
        if (v2 != null) {
            this.actual.onSuccess(v2);
        } else {
            this.actual.onError(new NoSuchElementException());
        }
    }
}

