/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;

final class ObservableSkipWhile$SkipWhileObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final Predicate<? super T> predicate;
    Disposable s;
    boolean notSkipping;

    ObservableSkipWhile$SkipWhileObserver(Observer<? super T> actual, Predicate<? super T> predicate) {
        this.actual = actual;
        this.predicate = predicate;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        if (this.notSkipping) {
            this.actual.onNext(t2);
        } else {
            boolean b2;
            try {
                b2 = this.predicate.test(t2);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.s.dispose();
                this.actual.onError(e2);
                return;
            }
            if (!b2) {
                this.notSkipping = true;
                this.actual.onNext(t2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }
}

