/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class ObservableTakeLastTimed$TakeLastTimedObserver<T>
extends AtomicBoolean
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -5677354903406201275L;
    final Observer<? super T> actual;
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final SpscLinkedArrayQueue<Object> queue;
    final boolean delayError;
    Disposable d;
    volatile boolean cancelled;
    Throwable error;

    ObservableTakeLastTimed$TakeLastTimedObserver(Observer<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        this.actual = actual;
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.queue = new SpscLinkedArrayQueue(bufferSize);
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        long ts2;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        long now = this.scheduler.now(this.unit);
        long time = this.time;
        long c2 = this.count;
        boolean unbounded = c2 == Long.MAX_VALUE;
        q2.offer(now, t2);
        while (!q2.isEmpty() && ((ts2 = ((Long)q2.peek()).longValue()) <= now - time || !unbounded && (long)(q2.size() >> 1) > c2)) {
            q2.poll();
            q2.poll();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.drain();
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.d.dispose();
            if (this.compareAndSet(false, true)) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void drain() {
        if (!this.compareAndSet(false, true)) {
            return;
        }
        Observer<Object> a2 = this.actual;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        boolean delayError = this.delayError;
        while (true) {
            boolean empty;
            Throwable ex2;
            if (this.cancelled) {
                q2.clear();
                return;
            }
            if (!delayError && (ex2 = this.error) != null) {
                q2.clear();
                a2.onError(ex2);
                return;
            }
            Object ts2 = q2.poll();
            boolean bl2 = empty = ts2 == null;
            if (empty) {
                Throwable ex3 = this.error;
                if (ex3 != null) {
                    a2.onError(ex3);
                } else {
                    a2.onComplete();
                }
                return;
            }
            Object o2 = q2.poll();
            if ((Long)ts2 < this.scheduler.now(this.unit) - this.time) continue;
            a2.onNext(o2);
        }
    }
}

