/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableTimeout$OnTimeout;
import io.reactivex.internal.operators.observable.ObservableTimeout$TimeoutInnerObserver;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableTimeout$TimeoutObserver<T, U, V>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable,
ObservableTimeout$OnTimeout {
    private static final long serialVersionUID = 2672739326310051084L;
    final Observer<? super T> actual;
    final ObservableSource<U> firstTimeoutIndicator;
    final Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator;
    Disposable s;
    volatile long index;

    ObservableTimeout$TimeoutObserver(Observer<? super T> actual, ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator) {
        this.actual = actual;
        this.firstTimeoutIndicator = firstTimeoutIndicator;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            Observer<T> a2 = this.actual;
            ObservableSource<U> p2 = this.firstTimeoutIndicator;
            if (p2 != null) {
                ObservableTimeout$TimeoutInnerObserver tis = new ObservableTimeout$TimeoutInnerObserver(this, 0L);
                if (this.compareAndSet(null, tis)) {
                    a2.onSubscribe(this);
                    p2.subscribe(tis);
                }
            } else {
                a2.onSubscribe(this);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        ObservableSource<V> p2;
        long idx;
        this.index = idx = this.index + 1L;
        this.actual.onNext(t2);
        Disposable d2 = (Disposable)this.get();
        if (d2 != null) {
            d2.dispose();
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The ObservableSource returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.dispose();
            this.actual.onError(e2);
            return;
        }
        ObservableTimeout$TimeoutInnerObserver tis = new ObservableTimeout$TimeoutInnerObserver(this, idx);
        if (this.compareAndSet(d2, tis)) {
            p2.subscribe(tis);
        }
    }

    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        DisposableHelper.dispose(this);
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        if (DisposableHelper.dispose(this)) {
            this.s.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void timeout(long idx) {
        if (idx == this.index) {
            this.dispose();
            this.actual.onError(new TimeoutException());
        }
    }

    @Override
    public void innerError(Throwable e2) {
        this.s.dispose();
        this.actual.onError(e2);
    }
}

