/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.ObserverFullArbiter;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.FullArbiterObserver;
import io.reactivex.internal.operators.observable.ObservableTimeout$OnTimeout;
import io.reactivex.internal.operators.observable.ObservableTimeout$TimeoutInnerObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableTimeout$TimeoutOtherObserver<T, U, V>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable,
ObservableTimeout$OnTimeout {
    private static final long serialVersionUID = -1957813281749686898L;
    final Observer<? super T> actual;
    final ObservableSource<U> firstTimeoutIndicator;
    final Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator;
    final ObservableSource<? extends T> other;
    final ObserverFullArbiter<T> arbiter;
    Disposable s;
    boolean done;
    volatile long index;

    ObservableTimeout$TimeoutOtherObserver(Observer<? super T> actual, ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, ObservableSource<? extends T> other) {
        this.actual = actual;
        this.firstTimeoutIndicator = firstTimeoutIndicator;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
        this.other = other;
        this.arbiter = new ObserverFullArbiter<T>(actual, this, 8);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.arbiter.setDisposable(s2);
            Observer<T> a2 = this.actual;
            ObservableSource<U> p2 = this.firstTimeoutIndicator;
            if (p2 != null) {
                ObservableTimeout$TimeoutInnerObserver tis = new ObservableTimeout$TimeoutInnerObserver(this, 0L);
                if (this.compareAndSet(null, tis)) {
                    a2.onSubscribe(this.arbiter);
                    p2.subscribe(tis);
                }
            } else {
                a2.onSubscribe(this.arbiter);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        ObservableSource<V> p2;
        long idx;
        if (this.done) {
            return;
        }
        this.index = idx = this.index + 1L;
        if (!this.arbiter.onNext(t2, this.s)) {
            return;
        }
        Disposable d2 = (Disposable)this.get();
        if (d2 != null) {
            d2.dispose();
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The ObservableSource returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            return;
        }
        ObservableTimeout$TimeoutInnerObserver tis = new ObservableTimeout$TimeoutInnerObserver(this, idx);
        if (this.compareAndSet(d2, tis)) {
            p2.subscribe(tis);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.dispose();
        this.arbiter.onError(t2, this.s);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.dispose();
        this.arbiter.onComplete(this.s);
    }

    @Override
    public void dispose() {
        if (DisposableHelper.dispose(this)) {
            this.s.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void timeout(long idx) {
        if (idx == this.index) {
            this.dispose();
            this.other.subscribe(new FullArbiterObserver<T>(this.arbiter));
        }
    }

    @Override
    public void innerError(Throwable e2) {
        this.s.dispose();
        this.actual.onError(e2);
    }
}

