/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.ObservableTimeoutTimed;
import io.reactivex.internal.operators.observable.ObservableTimeoutTimed$TimeoutTimedObserver$TimeoutTask;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableTimeoutTimed$TimeoutTimedObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -8387234228317808253L;
    final Observer<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    Disposable s;
    volatile long index;
    volatile boolean done;

    ObservableTimeoutTimed$TimeoutTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            this.scheduleTimeout(0L);
        }
    }

    @Override
    public void onNext(T t2) {
        long idx;
        if (this.done) {
            return;
        }
        this.index = idx = this.index + 1L;
        this.actual.onNext(t2);
        this.scheduleTimeout(idx);
    }

    void scheduleTimeout(long idx) {
        Disposable d2 = (Disposable)this.get();
        if (d2 != null) {
            d2.dispose();
        }
        if (this.compareAndSet(d2, ObservableTimeoutTimed.NEW_TIMER)) {
            d2 = this.worker.schedule(new ObservableTimeoutTimed$TimeoutTimedObserver$TimeoutTask(this, idx), this.timeout, this.unit);
            DisposableHelper.replace(this, d2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
        this.dispose();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
        this.dispose();
    }

    @Override
    public void dispose() {
        this.s.dispose();
        this.worker.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.worker.isDisposed();
    }
}

